/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.stats;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Counter;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Histogram;

public final class MetadataStoreStats
implements AutoCloseable {
    private static final double[] BUCKETS = new double[]{1.0, 3.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0};
    private static final String OPS_TYPE_LABEL_NAME = "type";
    private static final String METADATA_STORE_LABEL_NAME = "name";
    private static final String STATUS = "status";
    private static final String OPS_TYPE_GET = "get";
    private static final String OPS_TYPE_DEL = "del";
    private static final String OPS_TYPE_PUT = "put";
    private static final String STATUS_SUCCESS = "success";
    private static final String STATUS_FAIL = "fail";
    protected static final String PREFIX = "pulsar_metadata_store_";
    private static final Histogram OPS_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build("pulsar_metadata_store_ops_latency", "-").unit("ms")).buckets(BUCKETS).labelNames("name", "type", "status")).register();
    private static final Counter PUT_BYTES = (Counter)((Counter.Builder)((Counter.Builder)Counter.build("pulsar_metadata_store_put", "-").unit("bytes")).labelNames("name")).register();
    public static final AttributeKey<String> METADATA_STORE_NAME = AttributeKey.stringKey((String)"pulsar.metadata.store.name");
    public static final String METADATA_STORE_PUT_BYTES_COUNTER_METRIC_NAME = "pulsar.broker.metadata.store.outgoing.size";
    private final Attributes attributes;
    private final LongCounter putBytesCounter;
    private final Histogram.Child getOpsSucceedChild;
    private final Histogram.Child delOpsSucceedChild;
    private final Histogram.Child putOpsSucceedChild;
    private final Histogram.Child getOpsFailedChild;
    private final Histogram.Child delOpsFailedChild;
    private final Histogram.Child putOpsFailedChild;
    private final Counter.Child putBytesChild;
    private final String metadataStoreName;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public MetadataStoreStats(String metadataStoreName, OpenTelemetry openTelemetry) {
        this.metadataStoreName = metadataStoreName;
        this.getOpsSucceedChild = (Histogram.Child)OPS_LATENCY.labels(metadataStoreName, OPS_TYPE_GET, STATUS_SUCCESS);
        this.delOpsSucceedChild = (Histogram.Child)OPS_LATENCY.labels(metadataStoreName, OPS_TYPE_DEL, STATUS_SUCCESS);
        this.putOpsSucceedChild = (Histogram.Child)OPS_LATENCY.labels(metadataStoreName, OPS_TYPE_PUT, STATUS_SUCCESS);
        this.getOpsFailedChild = (Histogram.Child)OPS_LATENCY.labels(metadataStoreName, OPS_TYPE_GET, STATUS_FAIL);
        this.delOpsFailedChild = (Histogram.Child)OPS_LATENCY.labels(metadataStoreName, OPS_TYPE_DEL, STATUS_FAIL);
        this.putOpsFailedChild = (Histogram.Child)OPS_LATENCY.labels(metadataStoreName, OPS_TYPE_PUT, STATUS_FAIL);
        this.putBytesChild = (Counter.Child)PUT_BYTES.labels(metadataStoreName);
        this.attributes = Attributes.of(METADATA_STORE_NAME, (Object)metadataStoreName);
        this.putBytesCounter = openTelemetry.getMeter("org.apache.pulsar").counterBuilder(METADATA_STORE_PUT_BYTES_COUNTER_METRIC_NAME).setDescription("The total amount of data written to the metadata store").setUnit("{By}").build();
    }

    public void recordGetOpsSucceeded(long millis) {
        this.getOpsSucceedChild.observe(millis);
    }

    public void recordDelOpsSucceeded(long millis) {
        this.delOpsSucceedChild.observe(millis);
    }

    public void recordPutOpsSucceeded(long millis, int bytes) {
        this.putOpsSucceedChild.observe(millis);
        this.putBytesChild.inc(bytes);
        this.putBytesCounter.add((long)bytes, this.attributes);
    }

    public void recordGetOpsFailed(long millis) {
        this.getOpsFailedChild.observe(millis);
    }

    public void recordDelOpsFailed(long millis) {
        this.delOpsFailedChild.observe(millis);
    }

    public void recordPutOpsFailed(long millis) {
        this.putOpsFailedChild.observe(millis);
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            OPS_LATENCY.remove(this.metadataStoreName, OPS_TYPE_GET, STATUS_SUCCESS);
            OPS_LATENCY.remove(this.metadataStoreName, OPS_TYPE_DEL, STATUS_SUCCESS);
            OPS_LATENCY.remove(this.metadataStoreName, OPS_TYPE_PUT, STATUS_SUCCESS);
            OPS_LATENCY.remove(this.metadataStoreName, OPS_TYPE_GET, STATUS_FAIL);
            OPS_LATENCY.remove(this.metadataStoreName, OPS_TYPE_DEL, STATUS_FAIL);
            OPS_LATENCY.remove(this.metadataStoreName, OPS_TYPE_PUT, STATUS_FAIL);
            PUT_BYTES.remove(this.metadataStoreName);
        }
    }
}

