/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.stats;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Gauge;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Histogram;
import org.apache.pulsar.metadata.impl.stats.MetadataStoreStats;

public final class BatchMetadataStoreStats
implements AutoCloseable {
    private static final double[] BUCKETS = new double[]{1.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0};
    private static final String NAME = "name";
    private static final Gauge EXECUTOR_QUEUE_SIZE = (Gauge)((Gauge.Builder)Gauge.build("pulsar_batch_metadata_store_executor_queue_size", "-").labelNames("name")).register();
    private static final Histogram OPS_WAITING = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build("pulsar_batch_metadata_store_queue_wait_time", "-").unit("ms")).labelNames("name")).buckets(BUCKETS).register();
    private static final Histogram BATCH_EXECUTE_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build("pulsar_batch_metadata_store_batch_execute_time", "-").unit("ms")).labelNames("name")).buckets(BUCKETS).register();
    private static final Histogram OPS_PER_BATCH = (Histogram)((Histogram.Builder)Histogram.build("pulsar_batch_metadata_store_batch_size", "-").labelNames("name")).buckets(BUCKETS).register();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ThreadPoolExecutor executor;
    private final String metadataStoreName;
    private final Histogram.Child batchOpsWaitingChild;
    private final Histogram.Child batchExecuteTimeChild;
    private final Histogram.Child opsPerBatchChild;
    public static final String EXECUTOR_QUEUE_SIZE_METRIC_NAME = "pulsar.broker.metadata.store.executor.queue.size";
    private final ObservableLongUpDownCounter batchMetadataStoreSizeCounter;

    public BatchMetadataStoreStats(String metadataStoreName, ExecutorService executor, OpenTelemetry openTelemetry) {
        ThreadPoolExecutor tx;
        this.executor = executor instanceof ThreadPoolExecutor ? (tx = (ThreadPoolExecutor)executor) : null;
        this.metadataStoreName = metadataStoreName;
        EXECUTOR_QUEUE_SIZE.setChild(new Gauge.Child(){

            @Override
            public double get() {
                return BatchMetadataStoreStats.this.getQueueSize();
            }
        }, metadataStoreName);
        this.batchOpsWaitingChild = (Histogram.Child)OPS_WAITING.labels(metadataStoreName);
        this.batchExecuteTimeChild = (Histogram.Child)BATCH_EXECUTE_TIME.labels(metadataStoreName);
        this.opsPerBatchChild = (Histogram.Child)OPS_PER_BATCH.labels(metadataStoreName);
        Meter meter = openTelemetry.getMeter("org.apache.pulsar");
        Attributes attributes = Attributes.of(MetadataStoreStats.METADATA_STORE_NAME, (Object)metadataStoreName);
        this.batchMetadataStoreSizeCounter = meter.upDownCounterBuilder(EXECUTOR_QUEUE_SIZE_METRIC_NAME).setDescription("The number of batch operations in the metadata store executor queue").setUnit("{operation}").buildWithCallback(measurement -> measurement.record((long)this.getQueueSize(), attributes));
    }

    private int getQueueSize() {
        return this.executor == null ? 0 : this.executor.getQueue().size();
    }

    public void recordOpWaiting(long millis) {
        this.batchOpsWaitingChild.observe(millis);
    }

    public void recordBatchExecuteTime(long millis) {
        this.batchExecuteTimeChild.observe(millis);
    }

    public void recordOpsInBatch(int ops) {
        this.opsPerBatchChild.observe(ops);
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            EXECUTOR_QUEUE_SIZE.remove(this.metadataStoreName);
            OPS_WAITING.remove(this.metadataStoreName);
            BATCH_EXECUTE_TIME.remove(this.metadataStoreName);
            OPS_PER_BATCH.remove(this.metadataStoreName);
            this.batchMetadataStoreSizeCounter.close();
        }
    }
}

