/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.Request;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.RequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ServerMetrics;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooTrace;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.ErrorTxn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverRequestProcessor.class);
    ObserverZooKeeperServer zks;
    RequestProcessor nextProcessor;
    LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    boolean finished = false;

    public ObserverRequestProcessor(ObserverZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ObserverRequestProcessor:" + zks.getServerId(), zks.getZooKeeperServerListener());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void run() {
        try {
            while (!this.finished) {
                ServerMetrics.getMetrics().LEARNER_REQUEST_PROCESSOR_QUEUE_SIZE.add(this.queuedRequests.size());
                Request request = this.queuedRequests.take();
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, 2L, 'F', request, "");
                }
                if (request != Request.requestOfDeath) {
                    if (!this.zks.authWriteRequest(request)) continue;
                    this.nextProcessor.processRequest(request);
                    if (request.isThrottled()) continue;
                    switch (request.type) {
                        case 9: {
                            this.zks.pendingSyncs.add(request);
                            this.zks.getObserver().request(request);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 19: 
                        case 20: 
                        case 21: {
                            this.zks.getObserver().request(request);
                            break;
                        }
                        case -11: 
                        case -10: {
                            if (request.isLocalSession()) break;
                            this.zks.getObserver().request(request);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException e) {
            this.handleException(this.getName(), e);
        }
        catch (Exception e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("ObserverRequestProcessor exited loop!");
    }

    @Override
    public void processRequest(Request request) {
        if (!this.finished) {
            Request upgradeRequest = null;
            try {
                upgradeRequest = this.zks.checkUpgradeSession(request);
            }
            catch (KeeperException ke) {
                if (request.getHdr() != null) {
                    request.getHdr().setType(-1);
                    request.setTxn(new ErrorTxn(ke.code().intValue()));
                }
                request.setException(ke);
                LOG.info("Error creating upgrade request", (Throwable)ke);
            }
            catch (IOException ie) {
                LOG.error("Unexpected error in upgrade", (Throwable)ie);
            }
            if (upgradeRequest != null) {
                this.queuedRequests.add(upgradeRequest);
            }
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

