/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework;

import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.Cli;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.Command;

public class CliCommand<GlobalFlagsT extends CliFlags, CommandFlagsT extends CliFlags>
implements Command<GlobalFlagsT> {
    private final String name;
    private String parent;
    protected CliSpec<CommandFlagsT> spec;

    public CliCommand(CliSpec<CommandFlagsT> spec) {
        this.spec = spec;
        this.name = spec.name();
        this.parent = spec.parent();
    }

    public void setParent(String parent) {
        this.parent = parent;
        this.spec = CliSpec.newBuilder(this.spec).withParent(parent).build();
    }

    @Override
    public String category() {
        return this.spec.category();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String path() {
        return this.parent + " " + this.name;
    }

    @Override
    public String description() {
        return this.spec.description();
    }

    @Override
    public Boolean apply(GlobalFlagsT globalFlags, String[] args) {
        int res = Cli.runCli(this.spec, args);
        return res == 0;
    }

    @Override
    public void usage() {
        Cli.printUsage(this.spec);
    }

    public String getUsage() {
        return this.spec.usage();
    }
}

