/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.affinity.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IsolatedProcessors {
    private static final Logger log = LoggerFactory.getLogger(IsolatedProcessors.class);
    private static final Charset ENCODING = StandardCharsets.US_ASCII;
    private static final String ISOLATED_CPU_PATH = "/sys/devices/system/cpu/isolated";

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    static SortedSet<Integer> get() throws IOException {
        return IsolatedProcessors.parseProcessorRange(new String(Files.readAllBytes(Paths.get(ISOLATED_CPU_PATH, new String[0])), ENCODING));
    }

    static SortedSet<Integer> parseProcessorRange(String range) {
        TreeSet<Integer> processors = new TreeSet<Integer>();
        for (String part : StringUtils.trim(range).split(",")) {
            if (part.contains("-")) {
                String[] parts = part.split("-");
                int first = Integer.parseInt(parts[0]);
                int last = Integer.parseInt(parts[1]);
                for (int i = first; i <= last; ++i) {
                    processors.add(i);
                }
                continue;
            }
            if (part.isEmpty()) continue;
            processors.add(Integer.parseInt(part));
        }
        return processors;
    }

    static void disableCpu(int cpu) throws IOException {
        IsolatedProcessors.changeCpuStatus(cpu, false);
    }

    static void enableCpu(int cpu) throws IOException {
        IsolatedProcessors.changeCpuStatus(cpu, true);
    }

    private static void changeCpuStatus(int cpu, boolean enable) throws IOException {
        boolean currentState;
        Path cpuPath = Paths.get(String.format("/sys/devices/system/cpu/cpu%d/online", cpu), new String[0]);
        boolean bl = currentState = Integer.parseInt(StringUtils.trim(new String(Files.readAllBytes(cpuPath), ENCODING))) != 0;
        if (currentState != enable) {
            Files.write(cpuPath, (enable ? "1\n" : "0\n").getBytes(ENCODING), StandardOpenOption.TRUNCATE_EXISTING);
            log.info("{} CPU {}", (Object)(enable ? "Enabled" : "Disabled"), (Object)cpu);
        }
    }

    private IsolatedProcessors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

