/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.google.re2j;

import org.apache.pulsar.functions.runtime.shaded.com.google.re2j.Characters;
import org.apache.pulsar.functions.runtime.shaded.com.google.re2j.UnicodeTables;

class Unicode {
    static final int MAX_RUNE = 0x10FFFF;
    static final int MAX_ASCII = 127;
    static final int MAX_LATIN1 = 255;
    static final int MIN_FOLD = 65;
    static final int MAX_FOLD = 66639;

    private static boolean is32(int[][] ranges, int r) {
        int lo = 0;
        int hi = ranges.length;
        while (lo < hi) {
            int m = lo + (hi - lo) / 2;
            int[] range = ranges[m];
            if (range[0] <= r && r <= range[1]) {
                return (r - range[0]) % range[2] == 0;
            }
            if (r < range[0]) {
                hi = m;
                continue;
            }
            lo = m + 1;
        }
        return false;
    }

    private static boolean is(int[][] ranges, int r) {
        if (r <= 255) {
            for (int[] range : ranges) {
                if (r > range[1]) continue;
                if (r < range[0]) {
                    return false;
                }
                return (r - range[0]) % range[2] == 0;
            }
            return false;
        }
        return ranges.length > 0 && r >= ranges[0][0] && Unicode.is32(ranges, r);
    }

    static boolean isUpper(int r) {
        if (r <= 255) {
            return Character.isUpperCase((char)r);
        }
        return Unicode.is(UnicodeTables.Upper, r);
    }

    static boolean isPrint(int r) {
        if (r <= 255) {
            return r >= 32 && r < 127 || r >= 161 && r != 173;
        }
        return Unicode.is(UnicodeTables.L, r) || Unicode.is(UnicodeTables.M, r) || Unicode.is(UnicodeTables.N, r) || Unicode.is(UnicodeTables.P, r) || Unicode.is(UnicodeTables.S, r);
    }

    static int simpleFold(int r) {
        if (r < UnicodeTables.CASE_ORBIT.length && UnicodeTables.CASE_ORBIT[r] != '\u0000') {
            return UnicodeTables.CASE_ORBIT[r];
        }
        int l = Characters.toLowerCase(r);
        if (l != r) {
            return l;
        }
        return Characters.toUpperCase(r);
    }

    private Unicode() {
    }
}

