/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import lombok.Generated;
import org.apache.pulsar.common.policies.data.NonPersistentPublisherStats;
import org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;
import org.apache.pulsar.common.stats.Rate;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.annotation.JsonIgnore;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class NonPersistentPublisherStatsImpl
extends PublisherStatsImpl
implements NonPersistentPublisherStats {
    public double msgDropRate;
    @JsonIgnore
    private final Rate msgDrop = new Rate();

    public NonPersistentPublisherStatsImpl add(NonPersistentPublisherStatsImpl stats) {
        Objects.requireNonNull(stats);
        super.add(stats);
        this.msgDropRate += stats.msgDropRate;
        return this;
    }

    @Override
    public void calculateRates() {
        super.calculateRates();
        this.msgDrop.calculateRate();
        this.msgDropRate = this.msgDrop.getRate();
    }

    public void recordMsgDrop(long numMessages) {
        this.msgDrop.recordEvent(numMessages);
    }

    @JsonIgnore
    public long getMsgDropCount() {
        return this.msgDrop.getTotalCount();
    }

    @Override
    @Generated
    public double getMsgDropRate() {
        return this.msgDropRate;
    }
}

