/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@FunctionalInterface
public interface Converter<T, E extends Throwable> {
    public static final Converter<?, RuntimeException> DEFAULT = s -> s;
    public static final Converter<Class<?>, ClassNotFoundException> CLASS = Class::forName;
    public static final Converter<File, NullPointerException> FILE = File::new;
    public static final Converter<Path, InvalidPathException> PATH = x$0 -> Paths.get(x$0, new String[0]);
    public static final Converter<Number, NumberFormatException> NUMBER = s -> s.indexOf(46) != -1 ? (Number)Double.valueOf(s) : (Number)Long.valueOf(s);
    public static final Converter<Object, ReflectiveOperationException> OBJECT = s -> CLASS.apply(s).getConstructor(new Class[0]).newInstance(new Object[0]);
    public static final Converter<URL, MalformedURLException> URL = URL::new;
    public static final Converter<Date, ParseException> DATE = s -> new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(s);

    public T apply(String var1) throws E;
}

