/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum;

import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.Follower;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.FollowerMXBean;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.ObserverMaster;

public class FollowerBean
extends ZooKeeperServerBean
implements FollowerMXBean {
    private final Follower follower;

    public FollowerBean(Follower follower, ZooKeeperServer zks) {
        super(zks);
        this.follower = follower;
    }

    @Override
    public String getName() {
        return "Follower";
    }

    @Override
    public String getQuorumAddress() {
        return this.follower.sock.toString();
    }

    @Override
    public String getLastQueuedZxid() {
        return "0x" + Long.toHexString(this.follower.getLastQueued());
    }

    @Override
    public int getPendingRevalidationCount() {
        return this.follower.getPendingRevalidationsCount();
    }

    @Override
    public long getElectionTimeTaken() {
        return this.follower.self.getElectionTimeTaken();
    }

    @Override
    public int getObserverMasterPacketSizeLimit() {
        return this.follower.om == null ? -1 : this.follower.om.getPktsSizeLimit();
    }

    @Override
    public void setObserverMasterPacketSizeLimit(int sizeLimit) {
        ObserverMaster.setPktsSizeLimit(sizeLimit);
    }

    @Override
    public int getMaxConcurrentSnapSyncs() {
        ObserverMaster om = this.follower.om;
        return om == null ? -1 : om.getMaxConcurrentSnapSyncs();
    }

    @Override
    public void setMaxConcurrentSnapSyncs(int maxConcurrentSnapshots) {
        ObserverMaster om = this.follower.om;
        if (om != null) {
            om.setMaxConcurrentSnapSyncs(maxConcurrentSnapshots);
        }
    }

    @Override
    public int getMaxConcurrentDiffSyncs() {
        ObserverMaster om = this.follower.om;
        return om == null ? -1 : om.getMaxConcurrentDiffSyncs();
    }

    @Override
    public void setMaxConcurrentDiffSyncs(int maxConcurrentDiffSyncs) {
        ObserverMaster om = this.follower.om;
        if (om != null) {
            om.setMaxConcurrentDiffSyncs(maxConcurrentDiffSyncs);
        }
    }
}

