/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto;

import java.util.concurrent.ExecutorService;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCounted;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.ReadEntryProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.ByteBufList;

public class BatchedReadEntryProcessor
extends ReadEntryProcessor {
    private long maxBatchReadSize;
    private final Recycler.Handle<BatchedReadEntryProcessor> recyclerHandle;
    private static final Recycler<BatchedReadEntryProcessor> RECYCLER = new Recycler<BatchedReadEntryProcessor>(){

        @Override
        protected BatchedReadEntryProcessor newObject(Recycler.Handle<BatchedReadEntryProcessor> handle) {
            return new BatchedReadEntryProcessor((Recycler.Handle)handle);
        }
    };

    public static BatchedReadEntryProcessor create(BookieProtocol.BatchedReadRequest request, BookieRequestHandler requestHandler, BookieRequestProcessor requestProcessor, ExecutorService fenceThreadPool, boolean throttleReadResponses, long maxBatchReadSize) {
        BatchedReadEntryProcessor rep = RECYCLER.get();
        rep.init(request, requestHandler, requestProcessor);
        rep.fenceThreadPool = fenceThreadPool;
        rep.throttleReadResponses = throttleReadResponses;
        rep.maxBatchReadSize = maxBatchReadSize;
        requestProcessor.onReadRequestStart(requestHandler.ctx().channel());
        return rep;
    }

    @Override
    protected ReferenceCounted readData() throws Exception {
        ByteBufList data = null;
        BookieProtocol.BatchedReadRequest batchRequest = (BookieProtocol.BatchedReadRequest)this.request;
        int maxCount = batchRequest.getMaxCount();
        if (maxCount <= 0) {
            maxCount = Integer.MAX_VALUE;
        }
        long maxSize = Math.min(batchRequest.getMaxSize(), this.maxBatchReadSize);
        long frameSize = 36L;
        for (int i = 0; i < maxCount; ++i) {
            try {
                ByteBuf entry = this.requestProcessor.getBookie().readEntry(((BookieProtocol.ReadRequest)this.request).getLedgerId(), ((BookieProtocol.ReadRequest)this.request).getEntryId() + (long)i);
                frameSize += (long)(entry.readableBytes() + 4);
                if (data == null) {
                    data = ByteBufList.get(entry);
                    continue;
                }
                if (frameSize > maxSize) {
                    entry.release();
                    break;
                }
                data.add(entry);
                continue;
            }
            catch (Throwable e) {
                if (data != null) break;
                throw e;
            }
        }
        return data;
    }

    @Override
    protected BookieProtocol.Response buildReadResponse(ReferenceCounted data) {
        return ResponseBuilder.buildBatchedReadResponse((ByteBufList)data, (BookieProtocol.BatchedReadRequest)this.request);
    }

    @Override
    public String toString() {
        BookieProtocol.BatchedReadRequest br = (BookieProtocol.BatchedReadRequest)this.request;
        return String.format("BatchedReadEntry(%d, %d %d, %d)", br.getLedgerId(), br.getEntryId(), br.getMaxCount(), br.getMaxSize());
    }

    @Override
    protected void recycle() {
        ((BookieProtocol.ReadRequest)this.request).recycle();
        super.reset();
        if (this.recyclerHandle != null) {
            this.recyclerHandle.recycle(this);
        }
    }

    private BatchedReadEntryProcessor(Recycler.Handle<BatchedReadEntryProcessor> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }
}

