/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.conf;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.conf.ConcurrentConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.CompositeConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.Configuration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.PropertiesConfiguration;

public abstract class ComponentConfiguration
implements Configuration {
    protected static final String DELIMITER = ".";
    private final String componentPrefix;
    private final CompositeConfiguration underlyingConf;
    private final Configuration conf;

    protected ComponentConfiguration(CompositeConfiguration underlyingConf, String componentPrefix) {
        this.underlyingConf = underlyingConf;
        this.conf = new ConcurrentConfiguration();
        this.componentPrefix = componentPrefix;
        this.loadConf(underlyingConf);
    }

    protected String getKeyName(String name) {
        return name;
    }

    public CompositeConfiguration getUnderlyingConf() {
        return this.underlyingConf;
    }

    public void loadConf(URL confURL) throws ConfigurationException {
        PropertiesConfiguration loadedConf = new PropertiesConfiguration(confURL);
        this.loadConf(loadedConf);
    }

    protected void loadConf(Configuration loadedConf) {
        loadedConf.getKeys().forEachRemaining(fullKey -> {
            if (fullKey.startsWith(this.componentPrefix)) {
                String componentKey = fullKey.substring(this.componentPrefix.length());
                this.setProperty(componentKey, loadedConf.getProperty((String)fullKey));
            }
        });
    }

    public void validate() throws ConfigurationException {
    }

    @Override
    public Configuration subset(String prefix) {
        return this.conf.subset(this.getKeyName(prefix));
    }

    @Override
    public boolean isEmpty() {
        return this.conf.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.conf.containsKey(this.getKeyName(key));
    }

    @Override
    public void addProperty(String key, Object value) {
        this.conf.addProperty(this.getKeyName(key), value);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.conf.setProperty(this.getKeyName(key), value);
    }

    @Override
    public void clearProperty(String key) {
        this.conf.clearProperty(this.getKeyName(key));
    }

    @Override
    public void clear() {
        this.conf.clear();
    }

    @Override
    public Object getProperty(String key) {
        return this.conf.getProperty(this.getKeyName(key));
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        return this.conf.getKeys(this.getKeyName(prefix));
    }

    @Override
    public Iterator<String> getKeys() {
        return this.conf.getKeys();
    }

    @Override
    public Properties getProperties(String key) {
        return this.conf.getProperties(this.getKeyName(key));
    }

    @Override
    public boolean getBoolean(String key) {
        return this.conf.getBoolean(this.getKeyName(key));
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.conf.getBoolean(this.getKeyName(key), defaultValue);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.conf.getBoolean(this.getKeyName(key), defaultValue);
    }

    @Override
    public byte getByte(String key) {
        return this.conf.getByte(this.getKeyName(key));
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        return this.conf.getByte(this.getKeyName(key), defaultValue);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return this.conf.getByte(this.getKeyName(key), defaultValue);
    }

    @Override
    public double getDouble(String key) {
        return this.conf.getDouble(this.getKeyName(key));
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.conf.getDouble(this.getKeyName(key), defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        return this.conf.getDouble(this.getKeyName(key), defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return this.conf.getFloat(this.getKeyName(key));
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.conf.getFloat(this.getKeyName(key), defaultValue);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return this.conf.getFloat(this.getKeyName(key), defaultValue);
    }

    @Override
    public int getInt(String key) {
        return this.conf.getInt(this.getKeyName(key));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.conf.getInt(this.getKeyName(key), defaultValue);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.conf.getInt(this.getKeyName(key), defaultValue);
    }

    @Override
    public long getLong(String key) {
        return this.conf.getLong(this.getKeyName(key));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.conf.getLong(this.getKeyName(key), defaultValue);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return this.conf.getLong(this.getKeyName(key), defaultValue);
    }

    @Override
    public short getShort(String key) {
        return this.conf.getShort(this.getKeyName(key));
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return this.conf.getShort(this.getKeyName(key), defaultValue);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return this.conf.getShort(this.getKeyName(key), defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.conf.getBigDecimal(this.getKeyName(key));
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.conf.getBigDecimal(this.getKeyName(key), defaultValue);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.conf.getBigInteger(this.getKeyName(key));
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.conf.getBigInteger(this.getKeyName(key), defaultValue);
    }

    @Override
    public String getString(String key) {
        return this.conf.getString(this.getKeyName(key));
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.conf.getString(this.getKeyName(key), defaultValue);
    }

    @Override
    public String[] getStringArray(String key) {
        return this.conf.getStringArray(this.getKeyName(key));
    }

    @Override
    public List<Object> getList(String key) {
        return this.conf.getList(this.getKeyName(key));
    }

    @Override
    public List<Object> getList(String key, List<?> defaultValue) {
        return this.conf.getList(this.getKeyName(key), defaultValue);
    }

    public String asJson() {
        try {
            return JsonUtil.toJson(this.toMap());
        }
        catch (JsonUtil.ParseJsonException e) {
            throw new RuntimeException("Failed to serialize the configuration as json", e);
        }
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Iterator<String> iterator = this.getKeys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object property = this.getProperty(key);
            if (property == null) continue;
            configMap.put(key, property.toString());
        }
        return configMap;
    }
}

