/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.config;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.javax.annotation.Nullable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.resolver.EndpointResolver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Backoff;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;

abstract class StorageClientSettings_Builder {
    private int numWorkerThreads;
    private String serviceUri;
    private EndpointResolver endpointResolver;
    private boolean usePlaintext;
    private String clientName = null;
    private StatsLogger statsLogger = null;
    private Backoff.Policy backoffPolicy;
    private boolean enableServerSideRouting;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    StorageClientSettings_Builder() {
    }

    public static StorageClientSettings.Builder from(StorageClientSettings value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return StorageClientSettings.newBuilder().mergeFrom(value);
    }

    public StorageClientSettings.Builder numWorkerThreads(int numWorkerThreads) {
        this.numWorkerThreads = numWorkerThreads;
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapNumWorkerThreads(IntUnaryOperator mapper) {
        return this.numWorkerThreads(mapper.applyAsInt(this.numWorkerThreads()));
    }

    public int numWorkerThreads() {
        return this.numWorkerThreads;
    }

    public StorageClientSettings.Builder serviceUri(String serviceUri) {
        this.serviceUri = Objects.requireNonNull(serviceUri);
        this._unsetProperties.remove((Object)Property.SERVICE_URI);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapServiceUri(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.serviceUri((String)mapper.apply(this.serviceUri()));
    }

    public String serviceUri() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.SERVICE_URI), "serviceUri not set");
        return this.serviceUri;
    }

    public StorageClientSettings.Builder endpointResolver(EndpointResolver endpointResolver) {
        this.endpointResolver = Objects.requireNonNull(endpointResolver);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapEndpointResolver(UnaryOperator<EndpointResolver> mapper) {
        return this.endpointResolver((EndpointResolver)mapper.apply(this.endpointResolver()));
    }

    public EndpointResolver endpointResolver() {
        return this.endpointResolver;
    }

    public StorageClientSettings.Builder usePlaintext(boolean usePlaintext) {
        this.usePlaintext = usePlaintext;
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapUsePlaintext(UnaryOperator<Boolean> mapper) {
        return this.usePlaintext((Boolean)mapper.apply(this.usePlaintext()));
    }

    public boolean usePlaintext() {
        return this.usePlaintext;
    }

    public StorageClientSettings.Builder clientName(String clientName) {
        this.clientName = Objects.requireNonNull(clientName);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder clientName(Optional<? extends String> clientName) {
        if (clientName.isPresent()) {
            return this.clientName(clientName.get());
        }
        return this.clearClientName();
    }

    public StorageClientSettings.Builder nullableClientName(@Nullable String clientName) {
        if (clientName != null) {
            return this.clientName(clientName);
        }
        return this.clearClientName();
    }

    public StorageClientSettings.Builder mapClientName(UnaryOperator<String> mapper) {
        return this.clientName(this.clientName().map(mapper));
    }

    public StorageClientSettings.Builder clearClientName() {
        this.clientName = null;
        return (StorageClientSettings.Builder)this;
    }

    public Optional<String> clientName() {
        return Optional.ofNullable(this.clientName);
    }

    public StorageClientSettings.Builder statsLogger(StatsLogger statsLogger) {
        this.statsLogger = Objects.requireNonNull(statsLogger);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder statsLogger(Optional<? extends StatsLogger> statsLogger) {
        if (statsLogger.isPresent()) {
            return this.statsLogger(statsLogger.get());
        }
        return this.clearStatsLogger();
    }

    public StorageClientSettings.Builder nullableStatsLogger(@Nullable StatsLogger statsLogger) {
        if (statsLogger != null) {
            return this.statsLogger(statsLogger);
        }
        return this.clearStatsLogger();
    }

    public StorageClientSettings.Builder mapStatsLogger(UnaryOperator<StatsLogger> mapper) {
        return this.statsLogger(this.statsLogger().map(mapper));
    }

    public StorageClientSettings.Builder clearStatsLogger() {
        this.statsLogger = null;
        return (StorageClientSettings.Builder)this;
    }

    public Optional<StatsLogger> statsLogger() {
        return Optional.ofNullable(this.statsLogger);
    }

    public StorageClientSettings.Builder backoffPolicy(Backoff.Policy backoffPolicy) {
        this.backoffPolicy = Objects.requireNonNull(backoffPolicy);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapBackoffPolicy(UnaryOperator<Backoff.Policy> mapper) {
        return this.backoffPolicy((Backoff.Policy)mapper.apply(this.backoffPolicy()));
    }

    public Backoff.Policy backoffPolicy() {
        return this.backoffPolicy;
    }

    public StorageClientSettings.Builder enableServerSideRouting(boolean enableServerSideRouting) {
        this.enableServerSideRouting = enableServerSideRouting;
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mapEnableServerSideRouting(UnaryOperator<Boolean> mapper) {
        return this.enableServerSideRouting((Boolean)mapper.apply(this.enableServerSideRouting()));
    }

    public boolean enableServerSideRouting() {
        return this.enableServerSideRouting;
    }

    public StorageClientSettings.Builder mergeFrom(StorageClientSettings value) {
        StorageClientSettings.Builder defaults = StorageClientSettings.newBuilder();
        if (value.numWorkerThreads() != ((StorageClientSettings_Builder)defaults).numWorkerThreads()) {
            this.numWorkerThreads(value.numWorkerThreads());
        }
        if (defaults._unsetProperties.contains((Object)Property.SERVICE_URI) || !Objects.equals(value.serviceUri(), ((StorageClientSettings_Builder)defaults).serviceUri())) {
            this.serviceUri(value.serviceUri());
        }
        if (!Objects.equals(value.endpointResolver(), ((StorageClientSettings_Builder)defaults).endpointResolver())) {
            this.endpointResolver(value.endpointResolver());
        }
        if (value.usePlaintext() != ((StorageClientSettings_Builder)defaults).usePlaintext()) {
            this.usePlaintext(value.usePlaintext());
        }
        value.clientName().ifPresent(this::clientName);
        value.statsLogger().ifPresent(this::statsLogger);
        if (!Objects.equals(value.backoffPolicy(), ((StorageClientSettings_Builder)defaults).backoffPolicy())) {
            this.backoffPolicy(value.backoffPolicy());
        }
        if (value.enableServerSideRouting() != ((StorageClientSettings_Builder)defaults).enableServerSideRouting()) {
            this.enableServerSideRouting(value.enableServerSideRouting());
        }
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder mergeFrom(StorageClientSettings.Builder template) {
        StorageClientSettings.Builder defaults = StorageClientSettings.newBuilder();
        if (template.numWorkerThreads() != ((StorageClientSettings_Builder)defaults).numWorkerThreads()) {
            this.numWorkerThreads(template.numWorkerThreads());
        }
        StorageClientSettings.Builder base = template;
        if (!(base._unsetProperties.contains((Object)Property.SERVICE_URI) || !defaults._unsetProperties.contains((Object)Property.SERVICE_URI) && Objects.equals(template.serviceUri(), ((StorageClientSettings_Builder)defaults).serviceUri()))) {
            this.serviceUri(template.serviceUri());
        }
        if (!Objects.equals(template.endpointResolver(), ((StorageClientSettings_Builder)defaults).endpointResolver())) {
            this.endpointResolver(template.endpointResolver());
        }
        if (template.usePlaintext() != ((StorageClientSettings_Builder)defaults).usePlaintext()) {
            this.usePlaintext(template.usePlaintext());
        }
        template.clientName().ifPresent(this::clientName);
        template.statsLogger().ifPresent(this::statsLogger);
        if (!Objects.equals(template.backoffPolicy(), ((StorageClientSettings_Builder)defaults).backoffPolicy())) {
            this.backoffPolicy(template.backoffPolicy());
        }
        if (template.enableServerSideRouting() != ((StorageClientSettings_Builder)defaults).enableServerSideRouting()) {
            this.enableServerSideRouting(template.enableServerSideRouting());
        }
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings.Builder clear() {
        StorageClientSettings.Builder defaults = StorageClientSettings.newBuilder();
        this.numWorkerThreads = defaults.numWorkerThreads;
        this.serviceUri = defaults.serviceUri;
        this.endpointResolver = defaults.endpointResolver;
        this.usePlaintext = defaults.usePlaintext;
        this.clientName = defaults.clientName;
        this.statsLogger = defaults.statsLogger;
        this.backoffPolicy = defaults.backoffPolicy;
        this.enableServerSideRouting = defaults.enableServerSideRouting;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (StorageClientSettings.Builder)this;
    }

    public StorageClientSettings build() {
        Preconditions.checkState(this._unsetProperties.isEmpty(), "Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public StorageClientSettings buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final int numWorkerThreads;
        private final String serviceUri;
        private final EndpointResolver endpointResolver;
        private final boolean usePlaintext;
        private final String clientName;
        private final StatsLogger statsLogger;
        private final Backoff.Policy backoffPolicy;
        private final boolean enableServerSideRouting;
        private final EnumSet<Property> _unsetProperties;

        Partial(StorageClientSettings_Builder builder) {
            this.numWorkerThreads = builder.numWorkerThreads;
            this.serviceUri = builder.serviceUri;
            this.endpointResolver = builder.endpointResolver;
            this.usePlaintext = builder.usePlaintext;
            this.clientName = builder.clientName;
            this.statsLogger = builder.statsLogger;
            this.backoffPolicy = builder.backoffPolicy;
            this.enableServerSideRouting = builder.enableServerSideRouting;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public int numWorkerThreads() {
            return this.numWorkerThreads;
        }

        @Override
        public String serviceUri() {
            if (this._unsetProperties.contains((Object)Property.SERVICE_URI)) {
                throw new UnsupportedOperationException("serviceUri not set");
            }
            return this.serviceUri;
        }

        @Override
        public EndpointResolver endpointResolver() {
            return this.endpointResolver;
        }

        @Override
        public boolean usePlaintext() {
            return this.usePlaintext;
        }

        @Override
        public Optional<String> clientName() {
            return Optional.ofNullable(this.clientName);
        }

        @Override
        public Optional<StatsLogger> statsLogger() {
            return Optional.ofNullable(this.statsLogger);
        }

        @Override
        public Backoff.Policy backoffPolicy() {
            return this.backoffPolicy;
        }

        @Override
        public boolean enableServerSideRouting() {
            return this.enableServerSideRouting;
        }

        @Override
        public StorageClientSettings.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((StorageClientSettings_Builder)builder).numWorkerThreads = this.numWorkerThreads;
            ((StorageClientSettings_Builder)builder).serviceUri = this.serviceUri;
            ((StorageClientSettings_Builder)builder).endpointResolver = this.endpointResolver;
            ((StorageClientSettings_Builder)builder).usePlaintext = this.usePlaintext;
            ((StorageClientSettings_Builder)builder).clientName = this.clientName;
            ((StorageClientSettings_Builder)builder).statsLogger = this.statsLogger;
            ((StorageClientSettings_Builder)builder).backoffPolicy = this.backoffPolicy;
            ((StorageClientSettings_Builder)builder).enableServerSideRouting = this.enableServerSideRouting;
            ((StorageClientSettings_Builder)builder)._unsetProperties.clear();
            ((StorageClientSettings_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return this.numWorkerThreads == other.numWorkerThreads && Objects.equals(this.serviceUri, other.serviceUri) && Objects.equals(this.endpointResolver, other.endpointResolver) && this.usePlaintext == other.usePlaintext && Objects.equals(this.clientName, other.clientName) && Objects.equals(this.statsLogger, other.statsLogger) && Objects.equals(this.backoffPolicy, other.backoffPolicy) && this.enableServerSideRouting == other.enableServerSideRouting && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.numWorkerThreads, this.serviceUri, this.endpointResolver, this.usePlaintext, this.clientName, this.statsLogger, this.backoffPolicy, this.enableServerSideRouting, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial StorageClientSettings{numWorkerThreads=").append(this.numWorkerThreads);
            if (!this._unsetProperties.contains((Object)Property.SERVICE_URI)) {
                result.append(", serviceUri=").append(this.serviceUri);
            }
            result.append(", endpointResolver=").append(this.endpointResolver).append(", usePlaintext=").append(this.usePlaintext);
            if (this.clientName != null) {
                result.append(", clientName=").append(this.clientName);
            }
            if (this.statsLogger != null) {
                result.append(", statsLogger=").append(this.statsLogger);
            }
            return result.append(", backoffPolicy=").append(this.backoffPolicy).append(", enableServerSideRouting=").append(this.enableServerSideRouting).append("}").toString();
        }

        private static class PartialBuilder
        extends StorageClientSettings.Builder {
            private PartialBuilder() {
            }

            @Override
            public StorageClientSettings build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final int numWorkerThreads;
        private final String serviceUri;
        private final EndpointResolver endpointResolver;
        private final boolean usePlaintext;
        private final String clientName;
        private final StatsLogger statsLogger;
        private final Backoff.Policy backoffPolicy;
        private final boolean enableServerSideRouting;

        private Value(StorageClientSettings_Builder builder) {
            this.numWorkerThreads = builder.numWorkerThreads;
            this.serviceUri = builder.serviceUri;
            this.endpointResolver = builder.endpointResolver;
            this.usePlaintext = builder.usePlaintext;
            this.clientName = builder.clientName;
            this.statsLogger = builder.statsLogger;
            this.backoffPolicy = builder.backoffPolicy;
            this.enableServerSideRouting = builder.enableServerSideRouting;
        }

        @Override
        public int numWorkerThreads() {
            return this.numWorkerThreads;
        }

        @Override
        public String serviceUri() {
            return this.serviceUri;
        }

        @Override
        public EndpointResolver endpointResolver() {
            return this.endpointResolver;
        }

        @Override
        public boolean usePlaintext() {
            return this.usePlaintext;
        }

        @Override
        public Optional<String> clientName() {
            return Optional.ofNullable(this.clientName);
        }

        @Override
        public Optional<StatsLogger> statsLogger() {
            return Optional.ofNullable(this.statsLogger);
        }

        @Override
        public Backoff.Policy backoffPolicy() {
            return this.backoffPolicy;
        }

        @Override
        public boolean enableServerSideRouting() {
            return this.enableServerSideRouting;
        }

        @Override
        public StorageClientSettings.Builder toBuilder() {
            StorageClientSettings.Builder builder = StorageClientSettings.newBuilder();
            ((StorageClientSettings_Builder)builder).numWorkerThreads = this.numWorkerThreads;
            ((StorageClientSettings_Builder)builder).serviceUri = this.serviceUri;
            ((StorageClientSettings_Builder)builder).endpointResolver = this.endpointResolver;
            ((StorageClientSettings_Builder)builder).usePlaintext = this.usePlaintext;
            ((StorageClientSettings_Builder)builder).clientName = this.clientName;
            ((StorageClientSettings_Builder)builder).statsLogger = this.statsLogger;
            ((StorageClientSettings_Builder)builder).backoffPolicy = this.backoffPolicy;
            ((StorageClientSettings_Builder)builder).enableServerSideRouting = this.enableServerSideRouting;
            ((StorageClientSettings_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return this.numWorkerThreads == other.numWorkerThreads && Objects.equals(this.serviceUri, other.serviceUri) && Objects.equals(this.endpointResolver, other.endpointResolver) && this.usePlaintext == other.usePlaintext && Objects.equals(this.clientName, other.clientName) && Objects.equals(this.statsLogger, other.statsLogger) && Objects.equals(this.backoffPolicy, other.backoffPolicy) && this.enableServerSideRouting == other.enableServerSideRouting;
        }

        public int hashCode() {
            return Objects.hash(this.numWorkerThreads, this.serviceUri, this.endpointResolver, this.usePlaintext, this.clientName, this.statsLogger, this.backoffPolicy, this.enableServerSideRouting);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("StorageClientSettings{numWorkerThreads=").append(this.numWorkerThreads).append(", serviceUri=").append(this.serviceUri).append(", endpointResolver=").append(this.endpointResolver).append(", usePlaintext=").append(this.usePlaintext);
            if (this.clientName != null) {
                result.append(", clientName=").append(this.clientName);
            }
            if (this.statsLogger != null) {
                result.append(", statsLogger=").append(this.statsLogger);
            }
            return result.append(", backoffPolicy=").append(this.backoffPolicy).append(", enableServerSideRouting=").append(this.enableServerSideRouting).append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements StorageClientSettings {
        private Rebuildable() {
        }

        public abstract StorageClientSettings.Builder toBuilder();
    }

    private static enum Property {
        SERVICE_URI("serviceUri");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

