/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb;

import java.nio.ByteOrder;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.internal.PlatformDependent;

class ArrayUtil {
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();
    private static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    private static final boolean BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    ArrayUtil() {
    }

    public static long getLong(byte[] array, int index) {
        if (HAS_UNSAFE && UNALIGNED) {
            long v = PlatformDependent.getLong(array, index);
            return BIG_ENDIAN_NATIVE_ORDER ? v : Long.reverseBytes(v);
        }
        return ((long)array[index] & 0xFFL) << 56 | ((long)array[index + 1] & 0xFFL) << 48 | ((long)array[index + 2] & 0xFFL) << 40 | ((long)array[index + 3] & 0xFFL) << 32 | ((long)array[index + 4] & 0xFFL) << 24 | ((long)array[index + 5] & 0xFFL) << 16 | ((long)array[index + 6] & 0xFFL) << 8 | (long)array[index + 7] & 0xFFL;
    }

    public static void setLong(byte[] array, int index, long value) {
        if (HAS_UNSAFE && UNALIGNED) {
            PlatformDependent.putLong(array, index, BIG_ENDIAN_NATIVE_ORDER ? value : Long.reverseBytes(value));
        } else {
            array[index] = (byte)(value >>> 56);
            array[index + 1] = (byte)(value >>> 48);
            array[index + 2] = (byte)(value >>> 40);
            array[index + 3] = (byte)(value >>> 32);
            array[index + 4] = (byte)(value >>> 24);
            array[index + 5] = (byte)(value >>> 16);
            array[index + 6] = (byte)(value >>> 8);
            array[index + 7] = (byte)value;
        }
    }

    public static boolean isArrayAllZeros(byte[] array) {
        return PlatformDependent.isZero(array, 0, array.length);
    }
}

