/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.directentrylogger;

import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="Direct entry logger stats")
class DirectEntryLoggerStats {
    private static final String ADD_ENTRY = "entrylog-add-entry";
    private static final String READ_ENTRY = "entrylog-read-entry";
    private static final String FLUSH = "entrylog-flush";
    private static final String WRITER_FLUSH = "entrylog-writer-flush";
    private static final String READ_BLOCK = "entrylog-read-block";
    private static final String READER_OPEN = "entrylog-open-reader";
    private static final String READER_CLOSE = "entrylog-close-reader";
    private static final String CACHED_READER_SERVED_CLOSED = "entrylog-cached-reader-closed";
    @StatsDoc(name="entrylog-add-entry", help="Operation stats of adding entries to the entry log", parent="BOOKIE_ADD_ENTRY")
    private final OpStatsLogger addEntryStats;
    @StatsDoc(name="entrylog-read-entry", help="Operation stats of reading entries from the entry log", parent="BOOKIE_READ_ENTRY")
    private static ThreadLocal<OpStatsLogger> readEntryStats;
    @StatsDoc(name="entrylog-flush", help="Stats for persisting outstanding entrylog writes to disk")
    private final OpStatsLogger flushStats;
    @StatsDoc(name="entrylog-writer-flush", help="Stats for persisting outstanding entrylog writes for a single writer")
    private final OpStatsLogger writerFlushStats;
    @StatsDoc(name="entrylog-read-block", help="Stats for reading blocks from disk")
    private static ThreadLocal<OpStatsLogger> readBlockStats;
    @StatsDoc(name="entrylog-open-reader", help="Stats for reader open operations")
    private static ThreadLocal<Counter> openReaderStats;
    @StatsDoc(name="entrylog-close-reader", help="Stats for reader close operations")
    private static ThreadLocal<Counter> closeReaderStats;
    @StatsDoc(name="entrylog-cached-reader-closed", help="Stats for cached readers being served closed")
    private static ThreadLocal<Counter> cachedReadersServedClosed;

    DirectEntryLoggerStats(StatsLogger stats) {
        this.addEntryStats = stats.getOpStatsLogger(ADD_ENTRY);
        this.flushStats = stats.getOpStatsLogger(FLUSH);
        this.writerFlushStats = stats.getOpStatsLogger(WRITER_FLUSH);
        DirectEntryLoggerStats.setStats(stats);
    }

    private static synchronized void setStats(final StatsLogger stats) {
        readEntryStats = new ThreadLocal<OpStatsLogger>(){

            @Override
            public OpStatsLogger initialValue() {
                return stats.scopeLabel("thread", String.valueOf(Thread.currentThread().getId())).getOpStatsLogger(DirectEntryLoggerStats.READ_ENTRY);
            }
        };
        readBlockStats = new ThreadLocal<OpStatsLogger>(){

            @Override
            public OpStatsLogger initialValue() {
                return stats.scopeLabel("thread", String.valueOf(Thread.currentThread().getId())).getOpStatsLogger(DirectEntryLoggerStats.READ_BLOCK);
            }
        };
        openReaderStats = new ThreadLocal<Counter>(){

            @Override
            public Counter initialValue() {
                return stats.scopeLabel("thread", String.valueOf(Thread.currentThread().getId())).getCounter(DirectEntryLoggerStats.READER_OPEN);
            }
        };
        closeReaderStats = new ThreadLocal<Counter>(){

            @Override
            public Counter initialValue() {
                return stats.scopeLabel("thread", String.valueOf(Thread.currentThread().getId())).getCounter(DirectEntryLoggerStats.READER_CLOSE);
            }
        };
        cachedReadersServedClosed = new ThreadLocal<Counter>(){

            @Override
            public Counter initialValue() {
                return stats.scopeLabel("thread", String.valueOf(Thread.currentThread().getId())).getCounter(DirectEntryLoggerStats.CACHED_READER_SERVED_CLOSED);
            }
        };
    }

    OpStatsLogger getAddEntryStats() {
        return this.addEntryStats;
    }

    OpStatsLogger getFlushStats() {
        return this.flushStats;
    }

    OpStatsLogger getWriterFlushStats() {
        return this.writerFlushStats;
    }

    OpStatsLogger getReadEntryStats() {
        return readEntryStats.get();
    }

    OpStatsLogger getReadBlockStats() {
        return readBlockStats.get();
    }

    Counter getOpenReaderCounter() {
        return openReaderStats.get();
    }

    Counter getCloseReaderCounter() {
        return closeReaderStats.get();
    }

    Counter getCachedReadersServedClosedCounter() {
        return cachedReadersServedClosed.get();
    }
}

