/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.util.PrimitiveIterator;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.StateManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Watcher;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;

public interface Bookie {
    public void start();

    public void join() throws InterruptedException;

    public boolean isRunning();

    public int getExitCode();

    public int shutdown();

    public boolean isAvailableForHighPriorityWrites();

    public boolean isReadOnly();

    public void addEntry(ByteBuf var1, boolean var2, BookkeeperInternalCallbacks.WriteCallback var3, Object var4, byte[] var5) throws IOException, BookieException, InterruptedException;

    public void recoveryAddEntry(ByteBuf var1, BookkeeperInternalCallbacks.WriteCallback var2, Object var3, byte[] var4) throws IOException, BookieException, InterruptedException;

    public void forceLedger(long var1, BookkeeperInternalCallbacks.WriteCallback var3, Object var4);

    public void setExplicitLac(ByteBuf var1, BookkeeperInternalCallbacks.WriteCallback var2, Object var3, byte[] var4) throws IOException, InterruptedException, BookieException;

    public ByteBuf getExplicitLac(long var1) throws IOException, NoLedgerException, BookieException;

    public long getTotalDiskSpace() throws IOException;

    public long getTotalFreeSpace() throws IOException;

    public ByteBuf readEntry(long var1, long var3) throws IOException, NoLedgerException, BookieException;

    public long readLastAddConfirmed(long var1) throws IOException, BookieException;

    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long var1) throws IOException, NoLedgerException;

    public CompletableFuture<Boolean> fenceLedger(long var1, byte[] var3) throws IOException, BookieException;

    public boolean waitForLastAddConfirmedUpdate(long var1, long var3, Watcher<LastAddConfirmedUpdateNotification> var5) throws IOException;

    public void cancelWaitForLastAddConfirmedUpdate(long var1, Watcher<LastAddConfirmedUpdateNotification> var3) throws IOException;

    public StateManager getStateManager();

    public LedgerStorage getLedgerStorage();

    public static class NoEntryException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final long ledgerId;
        private final long entryId;

        public NoEntryException(long ledgerId, long entryId) {
            this("Entry " + entryId + " not found in " + ledgerId, ledgerId, entryId);
        }

        public NoEntryException(String msg, long ledgerId, long entryId) {
            super(msg);
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }

        public long getLedger() {
            return this.ledgerId;
        }

        public long getEntry() {
            return this.entryId;
        }
    }

    public static class NoLedgerException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final long ledgerId;

        public NoLedgerException(long ledgerId) {
            super("Ledger " + ledgerId + " not found");
            this.ledgerId = ledgerId;
        }

        public long getLedgerId() {
            return this.ledgerId;
        }
    }
}

