/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.functions.runtime.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.pulsar.functions.runtime.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.pulsar.functions.runtime.shaded.com.github.benmanes.caffeine.cache.Scheduler;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerCache
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerCache.class);
    private static final int PRODUCER_CACHE_TIMEOUT_SECONDS = Integer.parseInt(System.getenv().getOrDefault("PRODUCER_CACHE_TIMEOUT_SECONDS", "300"));
    private static final int PRODUCER_CACHE_MAX_SIZE = Integer.parseInt(System.getenv().getOrDefault("PRODUCER_CACHE_MAX_SIZE", "10000"));
    private static final int FLUSH_OR_CLOSE_TIMEOUT_SECONDS = 60;
    private final Cache<ProducerCacheKey, Producer<?>> cache;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<CompletableFuture<Void>> closeFutures = new CopyOnWriteArrayList();

    public ProducerCache() {
        Caffeine builder = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).removalListener((key, producer, cause) -> {
            log.info("Closing producer for topic {}, cause {}", (Object)key.topic(), (Object)cause);
            CompletionStage closeFuture = ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> producer.flushAsync(), Runnable::run).orTimeout(60L, TimeUnit.SECONDS).exceptionally(ex -> {
                Throwable unwrappedCause = FutureUtil.unwrapCompletionException(ex);
                if (unwrappedCause instanceof PulsarClientException.AlreadyClosedException) {
                    log.error("Error flushing producer for topic {} due to AlreadyClosedException", (Object)key.topic());
                } else {
                    log.error("Error flushing producer for topic {}", (Object)key.topic(), (Object)unwrappedCause);
                }
                return null;
            })).thenCompose(__ -> producer.closeAsync().orTimeout(60L, TimeUnit.SECONDS))).exceptionally(ex -> {
                Throwable unwrappedCause = FutureUtil.unwrapCompletionException(ex);
                if (unwrappedCause instanceof PulsarClientException.AlreadyClosedException) {
                    log.error("Error closing producer for topic {} due to AlreadyClosedException", (Object)key.topic());
                } else {
                    log.error("Error closing producer for topic {}", (Object)key.topic(), (Object)unwrappedCause);
                }
                return null;
            });
            if (this.closed.get()) {
                this.closeFutures.add((CompletableFuture<Void>)closeFuture);
            }
        }).weigher((key, producer) -> Math.max(producer.getNumOfPartitions(), 1)).maximumWeight((long)PRODUCER_CACHE_MAX_SIZE);
        if (PRODUCER_CACHE_TIMEOUT_SECONDS > 0) {
            builder.expireAfterAccess(Duration.ofSeconds(PRODUCER_CACHE_TIMEOUT_SECONDS));
        }
        this.cache = builder.build();
    }

    public <T> Producer<T> getOrCreateProducer(CacheArea cacheArea, String topicName, Object additionalCacheKey, Callable<Producer<T>> supplier) {
        if (this.closed.get()) {
            throw new IllegalStateException("ProducerCache is already closed");
        }
        return (Producer)this.cache.get((Object)new ProducerCacheKey(cacheArea, topicName, additionalCacheKey), key -> {
            try {
                return (Producer)supplier.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create producer for topic '" + topicName + "'", e);
            }
        });
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.cache.invalidateAll();
            try {
                FutureUtil.waitForAll(this.closeFutures).get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("Failed to close producers", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public boolean containsKey(CacheArea cacheArea, String topic) {
        return this.containsKey(cacheArea, topic, null);
    }

    @VisibleForTesting
    public boolean containsKey(CacheArea cacheArea, String topic, Object additionalCacheKey) {
        return this.cache.getIfPresent((Object)new ProducerCacheKey(cacheArea, topic, additionalCacheKey)) != null;
    }

    record ProducerCacheKey(CacheArea cacheArea, String topic, Object additionalKey) {
    }

    public static enum CacheArea {
        CONTEXT_CACHE,
        SINK_RECORD_CACHE;

    }
}

