/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.pulsar.functions.proto.Function;

public class InstanceConfig {
    private int instanceId;
    private String functionId;
    private String transformFunctionId;
    private String functionVersion;
    private Function.FunctionDetails functionDetails;
    private int maxBufferedTuples;
    private Function.FunctionAuthenticationSpec functionAuthenticationSpec;
    private int port;
    private String clusterName;
    private int maxPendingAsyncRequests = 1000;
    private boolean exposePulsarAdminClientEnabled = false;
    private int metricsPort;
    private List<String> additionalJavaRuntimeArguments = Collections.emptyList();

    public String getInstanceName() {
        return "" + this.instanceId;
    }

    public Function.FunctionDetails getFunctionDetails() {
        return this.functionDetails;
    }

    public boolean hasValidMetricsPort() {
        return this.metricsPort > 0 && this.metricsPort < 65536;
    }

    @Generated
    public InstanceConfig() {
    }

    @Generated
    public int getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public String getFunctionId() {
        return this.functionId;
    }

    @Generated
    public String getTransformFunctionId() {
        return this.transformFunctionId;
    }

    @Generated
    public String getFunctionVersion() {
        return this.functionVersion;
    }

    @Generated
    public int getMaxBufferedTuples() {
        return this.maxBufferedTuples;
    }

    @Generated
    public Function.FunctionAuthenticationSpec getFunctionAuthenticationSpec() {
        return this.functionAuthenticationSpec;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public int getMaxPendingAsyncRequests() {
        return this.maxPendingAsyncRequests;
    }

    @Generated
    public int getMetricsPort() {
        return this.metricsPort;
    }

    @Generated
    public List<String> getAdditionalJavaRuntimeArguments() {
        return this.additionalJavaRuntimeArguments;
    }

    @Generated
    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    @Generated
    public void setTransformFunctionId(String transformFunctionId) {
        this.transformFunctionId = transformFunctionId;
    }

    @Generated
    public void setFunctionVersion(String functionVersion) {
        this.functionVersion = functionVersion;
    }

    @Generated
    public void setFunctionDetails(Function.FunctionDetails functionDetails) {
        this.functionDetails = functionDetails;
    }

    @Generated
    public void setMaxBufferedTuples(int maxBufferedTuples) {
        this.maxBufferedTuples = maxBufferedTuples;
    }

    @Generated
    public void setFunctionAuthenticationSpec(Function.FunctionAuthenticationSpec functionAuthenticationSpec) {
        this.functionAuthenticationSpec = functionAuthenticationSpec;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Generated
    public void setMaxPendingAsyncRequests(int maxPendingAsyncRequests) {
        this.maxPendingAsyncRequests = maxPendingAsyncRequests;
    }

    @Generated
    public void setExposePulsarAdminClientEnabled(boolean exposePulsarAdminClientEnabled) {
        this.exposePulsarAdminClientEnabled = exposePulsarAdminClientEnabled;
    }

    @Generated
    public void setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
    }

    @Generated
    public void setAdditionalJavaRuntimeArguments(List<String> additionalJavaRuntimeArguments) {
        this.additionalJavaRuntimeArguments = additionalJavaRuntimeArguments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceConfig)) {
            return false;
        }
        InstanceConfig other = (InstanceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInstanceId() != other.getInstanceId()) {
            return false;
        }
        if (this.getMaxBufferedTuples() != other.getMaxBufferedTuples()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getMaxPendingAsyncRequests() != other.getMaxPendingAsyncRequests()) {
            return false;
        }
        if (this.isExposePulsarAdminClientEnabled() != other.isExposePulsarAdminClientEnabled()) {
            return false;
        }
        if (this.getMetricsPort() != other.getMetricsPort()) {
            return false;
        }
        String this$functionId = this.getFunctionId();
        String other$functionId = other.getFunctionId();
        if (this$functionId == null ? other$functionId != null : !this$functionId.equals(other$functionId)) {
            return false;
        }
        String this$transformFunctionId = this.getTransformFunctionId();
        String other$transformFunctionId = other.getTransformFunctionId();
        if (this$transformFunctionId == null ? other$transformFunctionId != null : !this$transformFunctionId.equals(other$transformFunctionId)) {
            return false;
        }
        String this$functionVersion = this.getFunctionVersion();
        String other$functionVersion = other.getFunctionVersion();
        if (this$functionVersion == null ? other$functionVersion != null : !this$functionVersion.equals(other$functionVersion)) {
            return false;
        }
        Function.FunctionDetails this$functionDetails = this.getFunctionDetails();
        Function.FunctionDetails other$functionDetails = other.getFunctionDetails();
        if (this$functionDetails == null ? other$functionDetails != null : !((Object)this$functionDetails).equals(other$functionDetails)) {
            return false;
        }
        Function.FunctionAuthenticationSpec this$functionAuthenticationSpec = this.getFunctionAuthenticationSpec();
        Function.FunctionAuthenticationSpec other$functionAuthenticationSpec = other.getFunctionAuthenticationSpec();
        if (this$functionAuthenticationSpec == null ? other$functionAuthenticationSpec != null : !((Object)this$functionAuthenticationSpec).equals(other$functionAuthenticationSpec)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        List<String> this$additionalJavaRuntimeArguments = this.getAdditionalJavaRuntimeArguments();
        List<String> other$additionalJavaRuntimeArguments = other.getAdditionalJavaRuntimeArguments();
        return !(this$additionalJavaRuntimeArguments == null ? other$additionalJavaRuntimeArguments != null : !((Object)this$additionalJavaRuntimeArguments).equals(other$additionalJavaRuntimeArguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InstanceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInstanceId();
        result = result * 59 + this.getMaxBufferedTuples();
        result = result * 59 + this.getPort();
        result = result * 59 + this.getMaxPendingAsyncRequests();
        result = result * 59 + (this.isExposePulsarAdminClientEnabled() ? 79 : 97);
        result = result * 59 + this.getMetricsPort();
        String $functionId = this.getFunctionId();
        result = result * 59 + ($functionId == null ? 43 : $functionId.hashCode());
        String $transformFunctionId = this.getTransformFunctionId();
        result = result * 59 + ($transformFunctionId == null ? 43 : $transformFunctionId.hashCode());
        String $functionVersion = this.getFunctionVersion();
        result = result * 59 + ($functionVersion == null ? 43 : $functionVersion.hashCode());
        Function.FunctionDetails $functionDetails = this.getFunctionDetails();
        result = result * 59 + ($functionDetails == null ? 43 : ((Object)$functionDetails).hashCode());
        Function.FunctionAuthenticationSpec $functionAuthenticationSpec = this.getFunctionAuthenticationSpec();
        result = result * 59 + ($functionAuthenticationSpec == null ? 43 : ((Object)$functionAuthenticationSpec).hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        List<String> $additionalJavaRuntimeArguments = this.getAdditionalJavaRuntimeArguments();
        result = result * 59 + ($additionalJavaRuntimeArguments == null ? 43 : ((Object)$additionalJavaRuntimeArguments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InstanceConfig(instanceId=" + this.getInstanceId() + ", functionId=" + this.getFunctionId() + ", transformFunctionId=" + this.getTransformFunctionId() + ", functionVersion=" + this.getFunctionVersion() + ", functionDetails=" + String.valueOf(this.getFunctionDetails()) + ", maxBufferedTuples=" + this.getMaxBufferedTuples() + ", functionAuthenticationSpec=" + String.valueOf(this.getFunctionAuthenticationSpec()) + ", port=" + this.getPort() + ", clusterName=" + this.getClusterName() + ", maxPendingAsyncRequests=" + this.getMaxPendingAsyncRequests() + ", exposePulsarAdminClientEnabled=" + this.isExposePulsarAdminClientEnabled() + ", metricsPort=" + this.getMetricsPort() + ", additionalJavaRuntimeArguments=" + String.valueOf(this.getAdditionalJavaRuntimeArguments()) + ")";
    }

    @Generated
    public boolean isExposePulsarAdminClientEnabled() {
        return this.exposePulsarAdminClientEnabled;
    }
}

