/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.annotation.JsonIgnore;

public class ConsumerStatsImpl
implements ConsumerStats {
    public double msgRateOut;
    public double msgThroughputOut;
    public long bytesOutCounter;
    public long msgOutCounter;
    public double msgRateRedeliver;
    public double messageAckRate;
    public double chunkedMessageRate;
    public String consumerName;
    public int availablePermits;
    public int unackedMessages;
    public int avgMessagesPerEntry;
    public boolean blockedConsumerOnUnackedMsgs;
    public String readPositionWhenJoining;
    @JsonIgnore
    private int addressOffset = -1;
    @JsonIgnore
    private int addressLength;
    @JsonIgnore
    private int connectedSinceOffset = -1;
    @JsonIgnore
    private int connectedSinceLength;
    @JsonIgnore
    private int clientVersionOffset = -1;
    @JsonIgnore
    private int clientVersionLength;
    @Deprecated
    public long lastAckedTimestamp;
    @Deprecated
    public long lastConsumedTimestamp;
    public long lastConsumedFlowTimestamp;
    public List<String> keyHashRanges;
    public Map<String, String> metadata;
    @JsonIgnore
    private StringBuilder stringBuffer = new StringBuilder();

    public ConsumerStatsImpl add(ConsumerStatsImpl stats) {
        Objects.requireNonNull(stats);
        this.msgRateOut += stats.msgRateOut;
        this.messageAckRate += stats.messageAckRate;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.bytesOutCounter += stats.bytesOutCounter;
        this.msgOutCounter += stats.msgOutCounter;
        this.msgRateRedeliver += stats.msgRateRedeliver;
        this.availablePermits += stats.availablePermits;
        this.unackedMessages += stats.unackedMessages;
        this.blockedConsumerOnUnackedMsgs = stats.blockedConsumerOnUnackedMsgs;
        this.readPositionWhenJoining = stats.readPositionWhenJoining;
        return this;
    }

    @Override
    public String getAddress() {
        return this.addressOffset == -1 ? null : this.stringBuffer.substring(this.addressOffset, this.addressOffset + this.addressLength);
    }

    public void setAddress(String address) {
        if (address == null) {
            this.addressOffset = -1;
            return;
        }
        this.addressOffset = this.stringBuffer.length();
        this.addressLength = address.length();
        this.stringBuffer.append(address);
    }

    @Override
    public String getConnectedSince() {
        return this.connectedSinceOffset == -1 ? null : this.stringBuffer.substring(this.connectedSinceOffset, this.connectedSinceOffset + this.connectedSinceLength);
    }

    public void setConnectedSince(String connectedSince) {
        if (connectedSince == null) {
            this.connectedSinceOffset = -1;
            return;
        }
        this.connectedSinceOffset = this.stringBuffer.length();
        this.connectedSinceLength = connectedSince.length();
        this.stringBuffer.append(connectedSince);
    }

    @Override
    public String getClientVersion() {
        return this.clientVersionOffset == -1 ? null : this.stringBuffer.substring(this.clientVersionOffset, this.clientVersionOffset + this.clientVersionLength);
    }

    public void setClientVersion(String clientVersion) {
        if (clientVersion == null) {
            this.clientVersionOffset = -1;
            return;
        }
        this.clientVersionOffset = this.stringBuffer.length();
        this.clientVersionLength = clientVersion.length();
        this.stringBuffer.append(clientVersion);
    }

    @Override
    public String getReadPositionWhenJoining() {
        return this.readPositionWhenJoining;
    }

    public String getLastAckedTime() {
        return DateFormatter.format(this.lastAckedTimestamp);
    }

    public String getLastConsumedTime() {
        return DateFormatter.format(this.lastConsumedTimestamp);
    }

    @Generated
    public ConsumerStatsImpl() {
    }

    @Override
    @Generated
    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    @Override
    @Generated
    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    @Override
    @Generated
    public long getBytesOutCounter() {
        return this.bytesOutCounter;
    }

    @Override
    @Generated
    public long getMsgOutCounter() {
        return this.msgOutCounter;
    }

    @Override
    @Generated
    public double getMsgRateRedeliver() {
        return this.msgRateRedeliver;
    }

    @Override
    @Generated
    public double getMessageAckRate() {
        return this.messageAckRate;
    }

    @Override
    @Generated
    public double getChunkedMessageRate() {
        return this.chunkedMessageRate;
    }

    @Override
    @Generated
    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    @Generated
    public int getAvailablePermits() {
        return this.availablePermits;
    }

    @Override
    @Generated
    public int getUnackedMessages() {
        return this.unackedMessages;
    }

    @Override
    @Generated
    public int getAvgMessagesPerEntry() {
        return this.avgMessagesPerEntry;
    }

    @Override
    @Generated
    public boolean isBlockedConsumerOnUnackedMsgs() {
        return this.blockedConsumerOnUnackedMsgs;
    }

    @Generated
    public int getAddressOffset() {
        return this.addressOffset;
    }

    @Generated
    public int getAddressLength() {
        return this.addressLength;
    }

    @Generated
    public int getConnectedSinceOffset() {
        return this.connectedSinceOffset;
    }

    @Generated
    public int getConnectedSinceLength() {
        return this.connectedSinceLength;
    }

    @Generated
    public int getClientVersionOffset() {
        return this.clientVersionOffset;
    }

    @Generated
    public int getClientVersionLength() {
        return this.clientVersionLength;
    }

    @Override
    @Deprecated
    @Generated
    public long getLastAckedTimestamp() {
        return this.lastAckedTimestamp;
    }

    @Override
    @Deprecated
    @Generated
    public long getLastConsumedTimestamp() {
        return this.lastConsumedTimestamp;
    }

    @Override
    @Generated
    public long getLastConsumedFlowTimestamp() {
        return this.lastConsumedFlowTimestamp;
    }

    @Override
    @Generated
    public List<String> getKeyHashRanges() {
        return this.keyHashRanges;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public StringBuilder getStringBuffer() {
        return this.stringBuffer;
    }

    @Generated
    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    @Generated
    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    @Generated
    public void setBytesOutCounter(long bytesOutCounter) {
        this.bytesOutCounter = bytesOutCounter;
    }

    @Generated
    public void setMsgOutCounter(long msgOutCounter) {
        this.msgOutCounter = msgOutCounter;
    }

    @Generated
    public void setMsgRateRedeliver(double msgRateRedeliver) {
        this.msgRateRedeliver = msgRateRedeliver;
    }

    @Generated
    public void setMessageAckRate(double messageAckRate) {
        this.messageAckRate = messageAckRate;
    }

    @Generated
    public void setChunkedMessageRate(double chunkedMessageRate) {
        this.chunkedMessageRate = chunkedMessageRate;
    }

    @Generated
    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    @Generated
    public void setAvailablePermits(int availablePermits) {
        this.availablePermits = availablePermits;
    }

    @Generated
    public void setUnackedMessages(int unackedMessages) {
        this.unackedMessages = unackedMessages;
    }

    @Generated
    public void setAvgMessagesPerEntry(int avgMessagesPerEntry) {
        this.avgMessagesPerEntry = avgMessagesPerEntry;
    }

    @Generated
    public void setBlockedConsumerOnUnackedMsgs(boolean blockedConsumerOnUnackedMsgs) {
        this.blockedConsumerOnUnackedMsgs = blockedConsumerOnUnackedMsgs;
    }

    @Generated
    public void setReadPositionWhenJoining(String readPositionWhenJoining) {
        this.readPositionWhenJoining = readPositionWhenJoining;
    }

    @JsonIgnore
    @Generated
    public void setAddressOffset(int addressOffset) {
        this.addressOffset = addressOffset;
    }

    @JsonIgnore
    @Generated
    public void setAddressLength(int addressLength) {
        this.addressLength = addressLength;
    }

    @JsonIgnore
    @Generated
    public void setConnectedSinceOffset(int connectedSinceOffset) {
        this.connectedSinceOffset = connectedSinceOffset;
    }

    @JsonIgnore
    @Generated
    public void setConnectedSinceLength(int connectedSinceLength) {
        this.connectedSinceLength = connectedSinceLength;
    }

    @JsonIgnore
    @Generated
    public void setClientVersionOffset(int clientVersionOffset) {
        this.clientVersionOffset = clientVersionOffset;
    }

    @JsonIgnore
    @Generated
    public void setClientVersionLength(int clientVersionLength) {
        this.clientVersionLength = clientVersionLength;
    }

    @Deprecated
    @Generated
    public void setLastAckedTimestamp(long lastAckedTimestamp) {
        this.lastAckedTimestamp = lastAckedTimestamp;
    }

    @Deprecated
    @Generated
    public void setLastConsumedTimestamp(long lastConsumedTimestamp) {
        this.lastConsumedTimestamp = lastConsumedTimestamp;
    }

    @Generated
    public void setLastConsumedFlowTimestamp(long lastConsumedFlowTimestamp) {
        this.lastConsumedFlowTimestamp = lastConsumedFlowTimestamp;
    }

    @Generated
    public void setKeyHashRanges(List<String> keyHashRanges) {
        this.keyHashRanges = keyHashRanges;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    @Generated
    public void setStringBuffer(StringBuilder stringBuffer) {
        this.stringBuffer = stringBuffer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerStatsImpl)) {
            return false;
        }
        ConsumerStatsImpl other = (ConsumerStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (this.getBytesOutCounter() != other.getBytesOutCounter()) {
            return false;
        }
        if (this.getMsgOutCounter() != other.getMsgOutCounter()) {
            return false;
        }
        if (Double.compare(this.getMsgRateRedeliver(), other.getMsgRateRedeliver()) != 0) {
            return false;
        }
        if (Double.compare(this.getMessageAckRate(), other.getMessageAckRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getChunkedMessageRate(), other.getChunkedMessageRate()) != 0) {
            return false;
        }
        if (this.getAvailablePermits() != other.getAvailablePermits()) {
            return false;
        }
        if (this.getUnackedMessages() != other.getUnackedMessages()) {
            return false;
        }
        if (this.getAvgMessagesPerEntry() != other.getAvgMessagesPerEntry()) {
            return false;
        }
        if (this.isBlockedConsumerOnUnackedMsgs() != other.isBlockedConsumerOnUnackedMsgs()) {
            return false;
        }
        if (this.getAddressOffset() != other.getAddressOffset()) {
            return false;
        }
        if (this.getAddressLength() != other.getAddressLength()) {
            return false;
        }
        if (this.getConnectedSinceOffset() != other.getConnectedSinceOffset()) {
            return false;
        }
        if (this.getConnectedSinceLength() != other.getConnectedSinceLength()) {
            return false;
        }
        if (this.getClientVersionOffset() != other.getClientVersionOffset()) {
            return false;
        }
        if (this.getClientVersionLength() != other.getClientVersionLength()) {
            return false;
        }
        if (this.getLastAckedTimestamp() != other.getLastAckedTimestamp()) {
            return false;
        }
        if (this.getLastConsumedTimestamp() != other.getLastConsumedTimestamp()) {
            return false;
        }
        if (this.getLastConsumedFlowTimestamp() != other.getLastConsumedFlowTimestamp()) {
            return false;
        }
        String this$consumerName = this.getConsumerName();
        String other$consumerName = other.getConsumerName();
        if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
            return false;
        }
        String this$readPositionWhenJoining = this.getReadPositionWhenJoining();
        String other$readPositionWhenJoining = other.getReadPositionWhenJoining();
        if (this$readPositionWhenJoining == null ? other$readPositionWhenJoining != null : !this$readPositionWhenJoining.equals(other$readPositionWhenJoining)) {
            return false;
        }
        List<String> this$keyHashRanges = this.getKeyHashRanges();
        List<String> other$keyHashRanges = other.getKeyHashRanges();
        if (this$keyHashRanges == null ? other$keyHashRanges != null : !((Object)this$keyHashRanges).equals(other$keyHashRanges)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        StringBuilder this$stringBuffer = this.getStringBuffer();
        StringBuilder other$stringBuffer = other.getStringBuffer();
        return !(this$stringBuffer == null ? other$stringBuffer != null : !this$stringBuffer.equals(other$stringBuffer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConsumerStatsImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $bytesOutCounter = this.getBytesOutCounter();
        result = result * 59 + (int)($bytesOutCounter >>> 32 ^ $bytesOutCounter);
        long $msgOutCounter = this.getMsgOutCounter();
        result = result * 59 + (int)($msgOutCounter >>> 32 ^ $msgOutCounter);
        long $msgRateRedeliver = Double.doubleToLongBits(this.getMsgRateRedeliver());
        result = result * 59 + (int)($msgRateRedeliver >>> 32 ^ $msgRateRedeliver);
        long $messageAckRate = Double.doubleToLongBits(this.getMessageAckRate());
        result = result * 59 + (int)($messageAckRate >>> 32 ^ $messageAckRate);
        long $chunkedMessageRate = Double.doubleToLongBits(this.getChunkedMessageRate());
        result = result * 59 + (int)($chunkedMessageRate >>> 32 ^ $chunkedMessageRate);
        result = result * 59 + this.getAvailablePermits();
        result = result * 59 + this.getUnackedMessages();
        result = result * 59 + this.getAvgMessagesPerEntry();
        result = result * 59 + (this.isBlockedConsumerOnUnackedMsgs() ? 79 : 97);
        result = result * 59 + this.getAddressOffset();
        result = result * 59 + this.getAddressLength();
        result = result * 59 + this.getConnectedSinceOffset();
        result = result * 59 + this.getConnectedSinceLength();
        result = result * 59 + this.getClientVersionOffset();
        result = result * 59 + this.getClientVersionLength();
        long $lastAckedTimestamp = this.getLastAckedTimestamp();
        result = result * 59 + (int)($lastAckedTimestamp >>> 32 ^ $lastAckedTimestamp);
        long $lastConsumedTimestamp = this.getLastConsumedTimestamp();
        result = result * 59 + (int)($lastConsumedTimestamp >>> 32 ^ $lastConsumedTimestamp);
        long $lastConsumedFlowTimestamp = this.getLastConsumedFlowTimestamp();
        result = result * 59 + (int)($lastConsumedFlowTimestamp >>> 32 ^ $lastConsumedFlowTimestamp);
        String $consumerName = this.getConsumerName();
        result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
        String $readPositionWhenJoining = this.getReadPositionWhenJoining();
        result = result * 59 + ($readPositionWhenJoining == null ? 43 : $readPositionWhenJoining.hashCode());
        List<String> $keyHashRanges = this.getKeyHashRanges();
        result = result * 59 + ($keyHashRanges == null ? 43 : ((Object)$keyHashRanges).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        StringBuilder $stringBuffer = this.getStringBuffer();
        result = result * 59 + ($stringBuffer == null ? 43 : $stringBuffer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConsumerStatsImpl(msgRateOut=" + this.getMsgRateOut() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", bytesOutCounter=" + this.getBytesOutCounter() + ", msgOutCounter=" + this.getMsgOutCounter() + ", msgRateRedeliver=" + this.getMsgRateRedeliver() + ", messageAckRate=" + this.getMessageAckRate() + ", chunkedMessageRate=" + this.getChunkedMessageRate() + ", consumerName=" + this.getConsumerName() + ", availablePermits=" + this.getAvailablePermits() + ", unackedMessages=" + this.getUnackedMessages() + ", avgMessagesPerEntry=" + this.getAvgMessagesPerEntry() + ", blockedConsumerOnUnackedMsgs=" + this.isBlockedConsumerOnUnackedMsgs() + ", readPositionWhenJoining=" + this.getReadPositionWhenJoining() + ", addressOffset=" + this.getAddressOffset() + ", addressLength=" + this.getAddressLength() + ", connectedSinceOffset=" + this.getConnectedSinceOffset() + ", connectedSinceLength=" + this.getConnectedSinceLength() + ", clientVersionOffset=" + this.getClientVersionOffset() + ", clientVersionLength=" + this.getClientVersionLength() + ", lastAckedTimestamp=" + this.getLastAckedTimestamp() + ", lastConsumedTimestamp=" + this.getLastConsumedTimestamp() + ", lastConsumedFlowTimestamp=" + this.getLastConsumedFlowTimestamp() + ", keyHashRanges=" + this.getKeyHashRanges() + ", metadata=" + this.getMetadata() + ", stringBuffer=" + this.getStringBuffer() + ")";
    }
}

