/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import java.util.Collection;
import lombok.Generated;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSkipUnknownPropertyHandler
extends DeserializationProblemHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicSkipUnknownPropertyHandler.class);
    private boolean skipUnknownProperty = true;

    @Override
    public boolean handleUnknownProperty(DeserializationContext deserializationContext, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
        Collection<Object> propIds = deserializer == null ? null : deserializer.getKnownPropertyNames();
        UnrecognizedPropertyException unrecognizedPropertyException = UnrecognizedPropertyException.from(p, beanOrClass, propertyName, propIds);
        if (this.skipUnknownProperty) {
            if (log.isDebugEnabled()) {
                log.debug(unrecognizedPropertyException.getMessage());
            }
            p.skipChildren();
            return this.skipUnknownProperty;
        }
        throw unrecognizedPropertyException;
    }

    @Generated
    public boolean isSkipUnknownProperty() {
        return this.skipUnknownProperty;
    }

    @Generated
    public void setSkipUnknownProperty(boolean skipUnknownProperty) {
        this.skipUnknownProperty = skipUnknownProperty;
    }
}

