/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.bookkeeper.HierarchicalLedgerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LongHierarchicalLedgerRangeIterator
implements LedgerManager.LedgerRangeIterator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LongHierarchicalLedgerRangeIterator.class);
    private final MetadataStore store;
    private final String ledgerRootPath;
    LedgerManager.LedgerRangeIterator rootIterator;

    LongHierarchicalLedgerRangeIterator(MetadataStore store, String ledgerRootPath) {
        this.store = store;
        this.ledgerRootPath = ledgerRootPath;
    }

    List<String> getChildrenAt(String path) throws IOException {
        try {
            return this.store.getChildren(path).get();
        }
        catch (ExecutionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get children at {}", (Object)path);
            }
            throw new IOException(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while reading ledgers at path " + path, ie);
        }
    }

    private void bootstrap() throws IOException {
        if (this.rootIterator == null) {
            this.rootIterator = new InnerIterator(this.ledgerRootPath, 0);
        }
    }

    @Override
    public synchronized boolean hasNext() throws IOException {
        this.bootstrap();
        return this.rootIterator.hasNext();
    }

    @Override
    public synchronized LedgerManager.LedgerRange next() throws IOException {
        this.bootstrap();
        return this.rootIterator.next();
    }

    public boolean isLedgerParentNode(String path) {
        return path.matches("\\d{3}");
    }

    private class InnerIterator
    implements LedgerManager.LedgerRangeIterator {
        final String path;
        final int level;
        final Iterator<String> thisLevelIterator;
        LedgerManager.LedgerRangeIterator nextLevelIterator;

        InnerIterator(String path, int level) throws IOException {
            this.path = path;
            this.level = level;
            this.thisLevelIterator = LongHierarchicalLedgerRangeIterator.this.getChildrenAt(path).iterator();
            this.advance();
        }

        void advance() throws IOException {
            while (this.thisLevelIterator.hasNext()) {
                LedgerManager.LedgerRangeIterator nextIterator;
                String node = this.thisLevelIterator.next();
                if (this.level == 0 && !LongHierarchicalLedgerRangeIterator.this.isLedgerParentNode(node) || !(nextIterator = this.level < 3 ? new InnerIterator(this.path + "/" + node, this.level + 1) : new LeafIterator(this.path + "/" + node)).hasNext()) continue;
                this.nextLevelIterator = nextIterator;
                break;
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.nextLevelIterator != null;
        }

        @Override
        public LedgerManager.LedgerRange next() throws IOException {
            LedgerManager.LedgerRange ret = this.nextLevelIterator.next();
            if (!this.nextLevelIterator.hasNext()) {
                this.nextLevelIterator = null;
                this.advance();
            }
            return ret;
        }
    }

    class LeafIterator
    implements LedgerManager.LedgerRangeIterator {
        LedgerManager.LedgerRange range;

        LeafIterator(String path) throws IOException {
            List<String> ledgerLeafNodes = LongHierarchicalLedgerRangeIterator.this.getChildrenAt(path);
            NavigableSet<Long> ledgerIds = HierarchicalLedgerUtils.ledgerListToSet(ledgerLeafNodes, LongHierarchicalLedgerRangeIterator.this.ledgerRootPath, path);
            if (log.isDebugEnabled()) {
                log.debug("All active ledgers from ZK for hash node {}: {}", (Object)path, ledgerIds);
            }
            if (!ledgerIds.isEmpty()) {
                this.range = new LedgerManager.LedgerRange(ledgerIds);
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.range != null;
        }

        @Override
        public LedgerManager.LedgerRange next() throws IOException {
            if (this.range == null) {
                throw new NoSuchElementException("next() must only be called if hasNext() is true");
            }
            LedgerManager.LedgerRange ret = this.range;
            this.range = null;
            return ret;
        }
    }
}

