/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.BookieServiceInfoUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.DataFormats;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieServiceInfoSerde
implements MetadataSerde<BookieServiceInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BookieServiceInfoSerde.class);
    static final BookieServiceInfoSerde INSTANCE = new BookieServiceInfoSerde();

    private BookieServiceInfoSerde() {
    }

    @Override
    public byte[] serialize(String path, BookieServiceInfo bookieServiceInfo) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("serialize BookieServiceInfo {}", (Object)bookieServiceInfo);
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            DataFormats.BookieServiceInfoFormat.Builder builder = DataFormats.BookieServiceInfoFormat.newBuilder();
            List bsiEndpoints = bookieServiceInfo.getEndpoints().stream().map(e -> DataFormats.BookieServiceInfoFormat.Endpoint.newBuilder().setId(e.getId()).setPort(e.getPort()).setHost(e.getHost()).setProtocol(e.getProtocol()).addAllAuth(e.getAuth()).addAllExtensions(e.getExtensions()).build()).collect(Collectors.toList());
            builder.addAllEndpoints(bsiEndpoints);
            builder.putAllProperties(bookieServiceInfo.getProperties());
            builder.build().writeTo(os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    @Override
    public BookieServiceInfo deserialize(String path, byte[] bookieServiceInfo, Stat stat) throws IOException {
        String bookieId = BookieServiceInfoSerde.extractBookiedIdFromPath(path);
        if (bookieServiceInfo == null || bookieServiceInfo.length == 0) {
            return BookieServiceInfoUtils.buildLegacyBookieServiceInfo(bookieId);
        }
        DataFormats.BookieServiceInfoFormat builder = DataFormats.BookieServiceInfoFormat.parseFrom(bookieServiceInfo);
        BookieServiceInfo bsi = new BookieServiceInfo();
        List<BookieServiceInfo.Endpoint> endpoints = builder.getEndpointsList().stream().map(e -> {
            BookieServiceInfo.Endpoint endpoint = new BookieServiceInfo.Endpoint();
            endpoint.setId(e.getId());
            endpoint.setPort(e.getPort());
            endpoint.setHost(e.getHost());
            endpoint.setProtocol(e.getProtocol());
            endpoint.setAuth(e.getAuthList());
            endpoint.setExtensions(e.getExtensionsList());
            return endpoint;
        }).collect(Collectors.toList());
        bsi.setEndpoints(endpoints);
        bsi.setProperties(builder.getPropertiesMap());
        return bsi;
    }

    private static String extractBookiedIdFromPath(String path) throws IOException {
        int last;
        if (path == null) {
            path = "";
        }
        if ((last = path.lastIndexOf("/")) >= 0) {
            return path.substring(last + 1);
        }
        throw new IOException("The path " + path + " doesn't look like a valid path for a BookieServiceInfo node");
    }
}

