/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl;

import java.util.function.Function;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.timeout.IdleStateEvent;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.impl.VertxByteBufAllocator;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.ConnectionBase;

public final class VertxHandler<C extends ConnectionBase>
extends ChannelDuplexHandler {
    private final Function<ChannelHandlerContext, C> connectionFactory;
    private C conn;
    private Handler<C> addHandler;
    private Handler<C> removeHandler;

    public static <C extends ConnectionBase> VertxHandler<C> create(Function<ChannelHandlerContext, C> connectionFactory) {
        return new VertxHandler<C>(connectionFactory);
    }

    private VertxHandler(Function<ChannelHandlerContext, C> connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public static ByteBuf safeBuffer(ByteBuf buf) {
        if (buf != Unpooled.EMPTY_BUFFER && (buf.alloc() instanceof PooledByteBufAllocator || buf instanceof CompositeByteBuf)) {
            try {
                if (buf.isReadable()) {
                    ByteBuf buffer = VertxByteBufAllocator.DEFAULT.heapBuffer(buf.readableBytes());
                    buffer.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
                    ByteBuf byteBuf = buffer;
                    return byteBuf;
                }
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            finally {
                buf.release();
            }
        }
        return buf;
    }

    private void setConnection(C connection) {
        this.conn = connection;
        if (this.addHandler != null) {
            this.addHandler.handle(connection);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.setConnection((ConnectionBase)this.connectionFactory.apply(ctx));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.removeHandler != null) {
            Handler<C> handler = this.removeHandler;
            this.removeHandler = null;
            handler.handle(this.conn);
        }
    }

    public VertxHandler<C> addHandler(Handler<C> handler) {
        this.addHandler = handler;
        return this;
    }

    public VertxHandler<C> removeHandler(Handler<C> handler) {
        this.removeHandler = handler;
        return this;
    }

    public C getConnection() {
        return this.conn;
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        C conn = this.getConnection();
        ((ConnectionBase)conn).handleInterestedOpsChanged();
    }

    public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) {
        C connection = this.getConnection();
        if (connection != null) {
            ((ConnectionBase)connection).handleException(t);
        }
        chctx.close();
    }

    public void channelInactive(ChannelHandlerContext chctx) {
        ((ConnectionBase)this.conn).handleClosed();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ((ConnectionBase)this.conn).endReadAndFlush();
    }

    public void channelRead(ChannelHandlerContext chctx, Object msg) {
        ((ConnectionBase)this.conn).read(msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ((ConnectionBase)this.conn).close(promise);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ((ConnectionBase)this.conn).handleIdle((IdleStateEvent)evt);
        }
        ((ConnectionBase)this.conn).handleEvent(evt);
    }
}

