/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto;

import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.Unpooled;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.RequestUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteEntryProcessorV3
extends PacketProcessorBaseV3 {
    private static final Logger logger = LoggerFactory.getLogger(WriteEntryProcessorV3.class);

    public WriteEntryProcessorV3(BookkeeperProtocol.Request request, BookieRequestHandler requestHandler, BookieRequestProcessor requestProcessor) {
        super(request, requestHandler, requestProcessor);
        requestProcessor.onAddRequestStart(requestHandler.ctx().channel());
    }

    private BookkeeperProtocol.AddResponse getAddResponse() {
        final long startTimeNanos = MathUtils.nowInNano();
        BookkeeperProtocol.AddRequest addRequest = this.request.getAddRequest();
        long ledgerId = addRequest.getLedgerId();
        long entryId = addRequest.getEntryId();
        final BookkeeperProtocol.AddResponse.Builder addResponse = BookkeeperProtocol.AddResponse.newBuilder().setLedgerId(ledgerId).setEntryId(entryId);
        if (!this.isVersionCompatible()) {
            addResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
            return addResponse.build();
        }
        if (!(!this.requestProcessor.getBookie().isReadOnly() || RequestUtils.isHighPriority(this.request) && this.requestProcessor.getBookie().isAvailableForHighPriorityWrites())) {
            logger.warn("BookieServer is running as readonly mode, so rejecting the request from the client!");
            addResponse.setStatus(BookkeeperProtocol.StatusCode.EREADONLY);
            return addResponse.build();
        }
        BookkeeperInternalCallbacks.WriteCallback wcb = new BookkeeperInternalCallbacks.WriteCallback(){

            @Override
            public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                BookkeeperProtocol.StatusCode status;
                if (0 == rc) {
                    WriteEntryProcessorV3.this.requestProcessor.getRequestStats().getAddEntryStats().registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
                } else {
                    WriteEntryProcessorV3.this.requestProcessor.getRequestStats().getAddEntryStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
                }
                switch (rc) {
                    case 0: {
                        status = BookkeeperProtocol.StatusCode.EOK;
                        break;
                    }
                    case 101: {
                        status = BookkeeperProtocol.StatusCode.EIO;
                        break;
                    }
                    default: {
                        status = BookkeeperProtocol.StatusCode.EUA;
                    }
                }
                addResponse.setStatus(status);
                BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(WriteEntryProcessorV3.this.getHeader()).setStatus(addResponse.getStatus()).setAddResponse(addResponse);
                BookkeeperProtocol.Response resp = response.build();
                WriteEntryProcessorV3.this.sendResponse(status, resp, WriteEntryProcessorV3.this.requestProcessor.getRequestStats().getAddRequestStats());
            }
        };
        EnumSet<WriteFlag> writeFlags = addRequest.hasWriteFlags() ? WriteFlag.getWriteFlags(addRequest.getWriteFlags()) : WriteFlag.NONE;
        boolean ackBeforeSync = writeFlags.contains((Object)WriteFlag.DEFERRED_SYNC);
        BookkeeperProtocol.StatusCode status = null;
        byte[] masterKey = addRequest.getMasterKey().toByteArray();
        ByteBuf entryToAdd = Unpooled.wrappedBuffer(addRequest.getBody().asReadOnlyByteBuffer());
        try {
            if (RequestUtils.hasFlag(addRequest, BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD)) {
                this.requestProcessor.getBookie().recoveryAddEntry(entryToAdd, wcb, this.requestHandler.ctx().channel(), masterKey);
            } else {
                this.requestProcessor.getBookie().addEntry(entryToAdd, ackBeforeSync, wcb, this.requestHandler.ctx().channel(), masterKey);
            }
            status = BookkeeperProtocol.StatusCode.EOK;
        }
        catch (BookieException.OperationRejectedException e) {
            this.requestProcessor.getRequestStats().getAddEntryRejectedCounter().inc();
            if (logger.isDebugEnabled()) {
                logger.debug("Operation rejected while writing {}", (Object)this.request, (Object)e);
            }
            status = BookkeeperProtocol.StatusCode.ETOOMANYREQUESTS;
        }
        catch (IOException e) {
            logger.error("Error writing entry:{} to ledger:{}", new Object[]{entryId, ledgerId, e});
            status = BookkeeperProtocol.StatusCode.EIO;
        }
        catch (BookieException.LedgerFencedException e) {
            logger.error("Ledger fenced while writing entry:{} to ledger:{}", new Object[]{entryId, ledgerId, e});
            status = BookkeeperProtocol.StatusCode.EFENCED;
        }
        catch (BookieException e) {
            logger.error("Unauthorized access to ledger:{} while writing entry:{}", new Object[]{ledgerId, entryId, e});
            status = BookkeeperProtocol.StatusCode.EUA;
        }
        catch (Throwable t) {
            logger.error("Unexpected exception while writing {}@{} : ", new Object[]{entryId, ledgerId, t});
            status = BookkeeperProtocol.StatusCode.EBADREQ;
        }
        if (!status.equals(BookkeeperProtocol.StatusCode.EOK)) {
            addResponse.setStatus(status);
            return addResponse.build();
        }
        return null;
    }

    @Override
    public void run() {
        this.requestProcessor.getRequestStats().getWriteThreadQueuedLatency().registerSuccessfulEvent(MathUtils.elapsedNanos(this.enqueueNanos), TimeUnit.NANOSECONDS);
        BookkeeperProtocol.AddResponse addResponse = this.getAddResponse();
        if (null != addResponse) {
            BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(addResponse.getStatus()).setAddResponse(addResponse);
            BookkeeperProtocol.Response resp = response.build();
            this.sendResponse(addResponse.getStatus(), resp, this.requestProcessor.getRequestStats().getAddRequestStats());
        }
    }

    @Override
    protected void sendResponse(BookkeeperProtocol.StatusCode code, Object response, OpStatsLogger statsLogger) {
        super.sendResponse(code, response, statsLogger);
        this.requestProcessor.onAddRequestFinish();
    }

    @Override
    public String toString() {
        return RequestUtils.toSafeString(this.request);
    }
}

