/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.proxy;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.CallOptions;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.HandlerRegistry;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.MethodDescriptor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerCallHandler;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerMethodDefinition;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerServiceDefinition;
import org.apache.pulsar.functions.runtime.shaded.javax.annotation.Nullable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.netty.IdentityInputStreamMarshaller;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.proxy.ChannelFinder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.proxy.ProxyServerCallHandler;

public class ProxyHandlerRegistry
extends HandlerRegistry {
    private final Map<String, ServerMethodDefinition<?, ?>> methods;

    private ProxyHandlerRegistry(Map<String, ServerMethodDefinition<?, ?>> methods) {
        this.methods = methods;
    }

    @Nullable
    public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
        return this.methods.get(methodName);
    }

    private static ServerMethodDefinition<?, ?> createProxyServerMethodDefinition(MethodDescriptor<?, ?> methodDesc, ServerCallHandler<InputStream, InputStream> handler) {
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder((MethodDescriptor.Marshaller)IdentityInputStreamMarshaller.of(), (MethodDescriptor.Marshaller)IdentityInputStreamMarshaller.of()).setFullMethodName(methodDesc.getFullMethodName()).setType(methodDesc.getType()).setIdempotent(methodDesc.isIdempotent()).setSafe(methodDesc.isSafe()).build();
        return ServerMethodDefinition.create((MethodDescriptor)methodDescriptor, handler);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HashMap<String, ServerServiceDefinition> services = new LinkedHashMap<String, ServerServiceDefinition>();
        private ChannelFinder finder;

        public Builder addService(ServerServiceDefinition service) {
            this.services.put(service.getServiceDescriptor().getName(), service);
            return this;
        }

        public Builder setChannelFinder(ChannelFinder finder) {
            this.finder = finder;
            return this;
        }

        public ProxyHandlerRegistry build() {
            Preconditions.checkNotNull(this.finder, "No channel finder defined");
            ProxyServerCallHandler proxyHandler = new ProxyServerCallHandler(this.finder, CallOptions.DEFAULT);
            HashMap<String, ServerMethodDefinition> methods = new HashMap<String, ServerMethodDefinition>();
            for (ServerServiceDefinition service : this.services.values()) {
                for (ServerMethodDefinition method : service.getMethods()) {
                    String methodName = method.getMethodDescriptor().getFullMethodName();
                    methods.put(methodName, ProxyHandlerRegistry.createProxyServerMethodDefinition(method.getMethodDescriptor(), (ServerCallHandler<InputStream, InputStream>)proxyHandler));
                }
            }
            return new ProxyHandlerRegistry(Collections.unmodifiableMap(methods));
        }
    }
}

