/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.AbstractComponent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.Lifecycle;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.LifecycleListener;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLifecycleComponent<ConfT extends ComponentConfiguration>
extends AbstractComponent<ConfT>
implements LifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(AbstractLifecycleComponent.class);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLifecycleComponent.class);
    protected final Lifecycle lifecycle = new Lifecycle();
    private final Set<LifecycleListener> listeners = new CopyOnWriteArraySet<LifecycleListener>();
    protected final StatsLogger statsLogger;
    protected volatile Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    protected AbstractLifecycleComponent(String componentName, ConfT conf, StatsLogger statsLogger) {
        super(componentName, conf);
        this.statsLogger = statsLogger;
    }

    @Override
    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.uncaughtExceptionHandler = handler;
    }

    protected StatsLogger getStatsLogger() {
        return this.statsLogger;
    }

    @Override
    public Lifecycle.State lifecycleState() {
        return this.lifecycle.state();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void start() {
        if (!this.lifecycle.canMoveToStarted()) {
            return;
        }
        this.listeners.forEach(LifecycleListener::beforeStart);
        try {
            this.doStart();
        }
        catch (Throwable exc) {
            LOG.error("Failed to start Component: {}", (Object)this.getName(), (Object)exc);
            if (this.uncaughtExceptionHandler != null) {
                LOG.error("Calling uncaughtExceptionHandler");
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), exc);
            }
            throw exc;
        }
        this.lifecycle.moveToStarted();
        this.listeners.forEach(LifecycleListener::afterStart);
    }

    protected abstract void doStart();

    @Override
    public void stop() {
        if (!this.lifecycle.canMoveToStopped()) {
            return;
        }
        this.listeners.forEach(LifecycleListener::beforeStop);
        this.lifecycle.moveToStopped();
        this.doStop();
        this.listeners.forEach(LifecycleListener::afterStop);
    }

    protected abstract void doStop();

    @Override
    public void close() {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.canMoveToClosed()) {
            return;
        }
        this.listeners.forEach(LifecycleListener::beforeClose);
        this.lifecycle.moveToClosed();
        try {
            this.doClose();
        }
        catch (IOException e) {
            log.warn("failed to close {}", (Object)this.componentName, (Object)e);
        }
        this.listeners.forEach(LifecycleListener::afterClose);
    }

    protected abstract void doClose() throws IOException;
}

