/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.PTable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.Txn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.result.KeyValueFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.result.ResultFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.Op;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.IncrementOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.PutOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv.DeleteRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv.IncrementRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv.KvUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv.PutRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv.RangeRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv.TxnRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Backoff;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RoutingHeader;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PByteBufTableRangeImpl
implements PTable<ByteBuf, ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(PByteBufTableRangeImpl.class);
    private final long streamId;
    private final RangeProperties rangeProps;
    private final StorageContainerChannel scChannel;
    private final ScheduledExecutorService executor;
    private final OpFactory<ByteBuf, ByteBuf> opFactory;
    private final ResultFactory<ByteBuf, ByteBuf> resultFactory;
    private final KeyValueFactory<ByteBuf, ByteBuf> kvFactory;
    private final Backoff.Policy backoffPolicy;

    PByteBufTableRangeImpl(long streamId, RangeProperties rangeProps, StorageContainerChannel scChannel, ScheduledExecutorService executor, OpFactory<ByteBuf, ByteBuf> opFactory, ResultFactory<ByteBuf, ByteBuf> resultFactory, KeyValueFactory<ByteBuf, ByteBuf> kvFactory, Backoff.Policy backoffPolicy) {
        this.streamId = streamId;
        this.rangeProps = rangeProps;
        this.scChannel = scChannel;
        this.executor = executor;
        this.opFactory = opFactory;
        this.resultFactory = resultFactory;
        this.kvFactory = kvFactory;
        this.backoffPolicy = backoffPolicy;
    }

    private RoutingHeader.Builder newRoutingHeader(ByteBuf pKey) {
        return RoutingHeader.newBuilder().setStreamId(this.streamId).setRangeId(this.rangeProps.getRangeId()).setRKey(UnsafeByteOperations.unsafeWrap(pKey.nioBuffer()));
    }

    @Override
    public CompletableFuture<RangeResult<ByteBuf, ByteBuf>> get(ByteBuf pKey, ByteBuf lKey, RangeOption<ByteBuf> option) {
        pKey.retain();
        lKey.retain();
        if (null != option.endKey()) {
            option.endKey().retain();
        }
        return RangeRequestProcessor.of(KvUtils.newRangeRequest(lKey, option).setHeader(this.newRoutingHeader(pKey)).build(), response -> KvUtils.newRangeResult(response, this.resultFactory, this.kvFactory), this.scChannel, this.executor, this.backoffPolicy).process().whenComplete((value, cause) -> {
            ReferenceCountUtil.release(pKey);
            ReferenceCountUtil.release(lKey);
            if (null != option.endKey()) {
                ReferenceCountUtil.release(option.endKey());
            }
        });
    }

    @Override
    public CompletableFuture<PutResult<ByteBuf, ByteBuf>> put(ByteBuf pKey, ByteBuf lKey, ByteBuf value, PutOption<ByteBuf> option) {
        pKey.retain();
        lKey.retain();
        value.retain();
        return PutRequestProcessor.of(KvUtils.newPutRequest(lKey, value, option).setHeader(this.newRoutingHeader(pKey)).build(), response -> KvUtils.newPutResult(response, this.resultFactory, this.kvFactory), this.scChannel, this.executor, this.backoffPolicy).process().whenComplete((ignored, cause) -> {
            ReferenceCountUtil.release(pKey);
            ReferenceCountUtil.release(lKey);
            ReferenceCountUtil.release(value);
        });
    }

    @Override
    public CompletableFuture<DeleteResult<ByteBuf, ByteBuf>> delete(ByteBuf pKey, ByteBuf lKey, DeleteOption<ByteBuf> option) {
        pKey.retain();
        lKey.retain();
        if (null != option.endKey()) {
            option.endKey().retain();
        }
        return DeleteRequestProcessor.of(KvUtils.newDeleteRequest(lKey, option).setHeader(this.newRoutingHeader(pKey)).build(), response -> KvUtils.newDeleteResult(response, this.resultFactory, this.kvFactory), this.scChannel, this.executor, this.backoffPolicy).process().whenComplete((ignored, cause) -> {
            ReferenceCountUtil.release(pKey);
            ReferenceCountUtil.release(lKey);
            if (null != option.endKey()) {
                ReferenceCountUtil.release(option.endKey());
            }
        });
    }

    @Override
    public CompletableFuture<IncrementResult<ByteBuf, ByteBuf>> increment(ByteBuf pKey, ByteBuf lKey, long amount, IncrementOption<ByteBuf> option) {
        pKey.retain();
        lKey.retain();
        return IncrementRequestProcessor.of(KvUtils.newIncrementRequest(lKey, amount, option).setHeader(this.newRoutingHeader(pKey)).build(), response -> KvUtils.newIncrementResult(response, this.resultFactory, this.kvFactory), this.scChannel, this.executor, this.backoffPolicy).process().whenComplete((ignored, cause) -> {
            ReferenceCountUtil.release(pKey);
            ReferenceCountUtil.release(lKey);
        });
    }

    @Override
    public Txn<ByteBuf, ByteBuf> txn(ByteBuf pKey) {
        return new TxnImpl(pKey);
    }

    @Override
    public void close() {
    }

    @Override
    public OpFactory<ByteBuf, ByteBuf> opFactory() {
        return this.opFactory;
    }

    class TxnImpl
    implements Txn<ByteBuf, ByteBuf> {
        private final ByteBuf pKey;
        private final TxnRequest.Builder txnBuilder;
        private final List<AutoCloseable> resourcesToRelease;

        TxnImpl(ByteBuf pKey) {
            this.pKey = pKey.retain();
            this.txnBuilder = TxnRequest.newBuilder();
            this.resourcesToRelease = Lists.newArrayList();
        }

        @Override
        public Txn<ByteBuf, ByteBuf> If(CompareOp ... cmps) {
            for (CompareOp cmp : cmps) {
                this.txnBuilder.addCompare(KvUtils.toProtoCompare(cmp));
                this.resourcesToRelease.add(cmp);
            }
            return this;
        }

        @Override
        public Txn<ByteBuf, ByteBuf> Then(Op ... ops) {
            for (Op op : ops) {
                this.txnBuilder.addSuccess(KvUtils.toProtoRequest(op));
                this.resourcesToRelease.add(op);
            }
            return this;
        }

        @Override
        public Txn<ByteBuf, ByteBuf> Else(Op ... ops) {
            for (Op op : ops) {
                this.txnBuilder.addFailure(KvUtils.toProtoRequest(op));
                this.resourcesToRelease.add(op);
            }
            return this;
        }

        @Override
        public CompletableFuture<TxnResult<ByteBuf, ByteBuf>> commit() {
            return TxnRequestProcessor.of(this.txnBuilder.setHeader(PByteBufTableRangeImpl.this.newRoutingHeader(this.pKey)).build(), response -> KvUtils.newKvTxnResult(response, PByteBufTableRangeImpl.this.resultFactory, PByteBufTableRangeImpl.this.kvFactory), PByteBufTableRangeImpl.this.scChannel, PByteBufTableRangeImpl.this.executor, PByteBufTableRangeImpl.this.backoffPolicy).process().whenComplete((ignored, cause) -> {
                ReferenceCountUtil.release(this.pKey);
                for (AutoCloseable resource : this.resourcesToRelease) {
                    this.closeResource(resource);
                }
            });
        }

        private void closeResource(AutoCloseable resource) {
            try {
                resource.close();
            }
            catch (Exception e) {
                log.warn("Fail to close resource {}", (Object)resource, (Object)e);
            }
        }
    }
}

