/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.ZoneawareEnsemblePlacementPolicyImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieNode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;

public class ZoneawareEnsemblePlacementPolicy
extends ZoneawareEnsemblePlacementPolicyImpl
implements ITopologyAwareEnsemblePlacementPolicy<BookieNode> {
    ZoneawareEnsemblePlacementPolicyImpl slave = null;

    @Override
    public EnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        if (conf.getNetworkTopologyStabilizePeriodSeconds() > 0) {
            ClientConfiguration confClone = new ClientConfiguration(conf);
            confClone.setNetworkTopologyStabilizePeriodSeconds(0);
            super.initialize(confClone, optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver);
            this.slave = new ZoneawareEnsemblePlacementPolicyImpl();
            this.slave.initialize(conf, optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver);
        } else {
            super.initialize(conf, optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver);
            this.slave = null;
        }
        return this;
    }

    @Override
    public void uninitalize() {
        super.uninitalize();
        if (null != this.slave) {
            this.slave.uninitalize();
        }
    }

    @Override
    public Set<BookieId> onClusterChanged(Set<BookieId> writableBookies, Set<BookieId> readOnlyBookies) {
        Set deadBookies = super.onClusterChanged((Set)writableBookies, (Set)readOnlyBookies);
        if (null != this.slave) {
            deadBookies = this.slave.onClusterChanged((Set)writableBookies, (Set)readOnlyBookies);
        }
        return deadBookies;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieId> leftBookies) {
        super.handleBookiesThatLeft((Set)leftBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatLeft((Set)leftBookies);
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieId> joinedBookies) {
        super.handleBookiesThatJoined((Set)joinedBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatJoined((Set)joinedBookies);
        }
    }
}

