/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.gzip.JdkGzipHadoopInputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.gzip.JdkGzipHadoopOutputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.hadoop.HadoopInputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.hadoop.HadoopOutputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.hadoop.HadoopStreams;

public class JdkGzipHadoopStreams
implements HadoopStreams {
    private static final int GZIP_BUFFER_SIZE = 8192;

    @Override
    public String getDefaultFileExtension() {
        return ".gz";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.GzipCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new JdkGzipHadoopInputStream(in, 8192);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new JdkGzipHadoopOutputStream(out, 8192);
    }
}

