/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.stream.IntStream;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.datatype.jdk8.WrappedIOException;

public class IntStreamSerializer
extends StdSerializer<IntStream> {
    private static final long serialVersionUID = 1L;
    public static final IntStreamSerializer INSTANCE = new IntStreamSerializer();

    private IntStreamSerializer() {
        super(IntStream.class);
    }

    @Override
    public void serialize(IntStream stream, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try (IntStream is = stream;){
            jgen.writeStartArray();
            is.forEachOrdered(value -> {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new WrappedIOException(e);
                }
            });
            jgen.writeEndArray();
        }
        catch (WrappedIOException e) {
            throw e.getCause();
        }
    }
}

