/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.stats;

import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.common.util.RateLimiter;
import org.apache.pulsar.functions.instance.stats.ComponentStatsManager;
import org.apache.pulsar.functions.instance.stats.FunctionCollectorRegistry;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.EvictingQueue;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Counter;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Gauge;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionStatsManager
extends ComponentStatsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionStatsManager.class);
    public static final String PULSAR_FUNCTION_METRICS_PREFIX = "pulsar_function_";
    public static final String PROCESSED_SUCCESSFULLY_TOTAL = "processed_successfully_total";
    public static final String SYSTEM_EXCEPTIONS_TOTAL = "system_exceptions_total";
    public static final String USER_EXCEPTIONS_TOTAL = "user_exceptions_total";
    public static final String SOURCE_EXCEPTIONS_TOTAL = "source_exceptions_total";
    public static final String SINK_EXCEPTIONS_TOTAL = "sink_exceptions_total";
    public static final String PROCESS_LATENCY_MS = "process_latency_ms";
    public static final String LAST_INVOCATION = "last_invocation";
    public static final String RECEIVED_TOTAL = "received_total";
    public static final String PROCESSED_SUCCESSFULLY_TOTAL_1min = "processed_successfully_1min";
    public static final String SYSTEM_EXCEPTIONS_TOTAL_1min = "system_exceptions_1min";
    public static final String USER_EXCEPTIONS_TOTAL_1min = "user_exceptions_1min";
    public static final String SOURCE_EXCEPTIONS_TOTAL_1min = "source_exceptions_1min";
    public static final String SINK_EXCEPTIONS_TOTAL_1min = "sink_exceptions_1min";
    public static final String PROCESS_LATENCY_MS_1min = "process_latency_ms_1min";
    public static final String RECEIVED_TOTAL_1min = "received_1min";
    final Counter statTotalProcessedSuccessfully;
    final Counter statTotalSysExceptions;
    final Counter statTotalUserExceptions;
    final Summary statProcessLatency;
    final Gauge statlastInvocation;
    final Counter statTotalRecordsReceived;
    final Counter statTotalProcessedSuccessfully1min;
    final Counter statTotalSysExceptions1min;
    final Counter statTotalUserExceptions1min;
    final Summary statProcessLatency1min;
    final Counter statTotalRecordsReceived1min;
    final Gauge userExceptions;
    final Gauge sysExceptions;
    final Gauge sourceExceptions;
    final Gauge sinkExceptions;
    private final Counter.Child statTotalProcessedSuccessfullyChild;
    private final Counter.Child statTotalSysExceptionsChild;
    private final Counter.Child statTotalUserExceptionsChild;
    private final Summary.Child statProcessLatencyChild;
    private final Gauge.Child statlastInvocationChild;
    private final Counter.Child statTotalRecordsReceivedChild;
    private Counter.Child statTotalProcessedSuccessfully1minChild;
    private Counter.Child statTotalSysExceptions1minChild;
    private Counter.Child statTotalUserExceptions1minChild;
    private Summary.Child statProcessLatency1minChild;
    private Counter.Child statTotalRecordsReceivedChild1min;
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestUserExceptions = EvictingQueue.create(10);
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSystemExceptions = EvictingQueue.create(10);
    private final RateLimiter userExceptionRateLimiter;
    private final RateLimiter sysExceptionRateLimiter;
    private Long processTimeStart;

    public FunctionStatsManager(FunctionCollectorRegistry collectorRegistry, String[] metricsLabels, ScheduledExecutorService scheduledExecutorService) {
        super(collectorRegistry, metricsLabels, scheduledExecutorService);
        this.statTotalProcessedSuccessfully = collectorRegistry.registerIfNotExist("pulsar_function_processed_successfully_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_function_processed_successfully_total")).help("Total number of messages processed successfully.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalProcessedSuccessfullyChild = (Counter.Child)this.statTotalProcessedSuccessfully.labels(metricsLabels);
        this.statTotalSysExceptions = collectorRegistry.registerIfNotExist("pulsar_function_system_exceptions_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_function_system_exceptions_total")).help("Total number of system exceptions.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalSysExceptionsChild = (Counter.Child)this.statTotalSysExceptions.labels(metricsLabels);
        this.statTotalUserExceptions = collectorRegistry.registerIfNotExist("pulsar_function_user_exceptions_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_function_user_exceptions_total")).help("Total number of user exceptions.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalUserExceptionsChild = (Counter.Child)this.statTotalUserExceptions.labels(metricsLabels);
        this.statProcessLatency = collectorRegistry.registerIfNotExist("pulsar_function_process_latency_ms", ((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_process_latency_ms")).help("Process latency in milliseconds.")).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(0.99, 0.01).quantile(0.999, 0.01).labelNames(METRICS_LABEL_NAMES)).create());
        this.statProcessLatencyChild = (Summary.Child)this.statProcessLatency.labels(metricsLabels);
        this.statlastInvocation = collectorRegistry.registerIfNotExist("pulsar_function_last_invocation", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_function_last_invocation")).help("The timestamp of the last invocation of the function.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statlastInvocationChild = (Gauge.Child)this.statlastInvocation.labels(metricsLabels);
        this.statTotalRecordsReceived = collectorRegistry.registerIfNotExist("pulsar_function_received_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_function_received_total")).help("Total number of messages received from source.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalRecordsReceivedChild = (Counter.Child)this.statTotalRecordsReceived.labels(metricsLabels);
        this.statTotalProcessedSuccessfully1min = collectorRegistry.registerIfNotExist("pulsar_function_processed_successfully_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_function_processed_successfully_1min")).help("Total number of messages processed successfully in the last 1 minute.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalProcessedSuccessfully1minChild = (Counter.Child)this.statTotalProcessedSuccessfully1min.labels(metricsLabels);
        this.statTotalSysExceptions1min = collectorRegistry.registerIfNotExist("pulsar_function_system_exceptions_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_function_system_exceptions_1min")).help("Total number of system exceptions in the last 1 minute.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalSysExceptions1minChild = (Counter.Child)this.statTotalSysExceptions1min.labels(metricsLabels);
        this.statTotalUserExceptions1min = collectorRegistry.registerIfNotExist("pulsar_function_user_exceptions_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_function_user_exceptions_1min")).help("Total number of user exceptions in the last 1 minute.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalUserExceptions1minChild = (Counter.Child)this.statTotalUserExceptions1min.labels(metricsLabels);
        this.statProcessLatency1min = collectorRegistry.registerIfNotExist("pulsar_function_process_latency_ms_1min", ((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("pulsar_function_process_latency_ms_1min")).help("Process latency in milliseconds in the last 1 minute.")).quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(0.99, 0.01).quantile(0.999, 0.01).labelNames(METRICS_LABEL_NAMES)).create());
        this.statProcessLatency1minChild = (Summary.Child)this.statProcessLatency1min.labels(metricsLabels);
        this.statTotalRecordsReceived1min = collectorRegistry.registerIfNotExist("pulsar_function_received_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_function_received_1min")).help("Total number of messages received from source in the last 1 minute.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalRecordsReceivedChild1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(metricsLabels);
        this.userExceptions = collectorRegistry.registerIfNotExist("pulsar_function_user_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_function_user_exception")).labelNames(EXCEPTION_METRICS_LABEL_NAMES)).help("Exception from user code.")).create());
        this.sysExceptions = collectorRegistry.registerIfNotExist("pulsar_function_system_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_function_system_exception")).labelNames(EXCEPTION_METRICS_LABEL_NAMES)).help("Exception from system code.")).create());
        this.sourceExceptions = collectorRegistry.registerIfNotExist("pulsar_function_source_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_function_source_exception")).labelNames(EXCEPTION_METRICS_LABEL_NAMES)).help("Exception from source.")).create());
        this.sinkExceptions = collectorRegistry.registerIfNotExist("pulsar_function_sink_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_function_sink_exception")).labelNames(EXCEPTION_METRICS_LABEL_NAMES)).help("Exception from sink.")).create());
        this.userExceptionRateLimiter = RateLimiter.builder().scheduledExecutorService(scheduledExecutorService).permits(5L).rateTime(1L).timeUnit(TimeUnit.MINUTES).build();
        this.sysExceptionRateLimiter = RateLimiter.builder().scheduledExecutorService(scheduledExecutorService).permits(5L).rateTime(1L).timeUnit(TimeUnit.MINUTES).build();
    }

    public void addUserException(Throwable ex) {
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestUserExceptions.add(info);
        if (this.userExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.userExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    public void addSystemException(Throwable ex) {
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSystemExceptions.add(info);
        if (this.sysExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sysExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    private String[] getExceptionMetricsLabels(Throwable ex) {
        String[] exceptionMetricsLabels = Arrays.copyOf(this.metricsLabels, this.metricsLabels.length + 1);
        exceptionMetricsLabels[exceptionMetricsLabels.length - 1] = ex.getMessage() != null ? ex.getMessage() : "";
        return exceptionMetricsLabels;
    }

    @Override
    public void incrTotalReceived() {
        this.statTotalRecordsReceivedChild.inc();
        this.statTotalRecordsReceivedChild1min.inc();
    }

    @Override
    public void incrTotalProcessedSuccessfully() {
        this.statTotalProcessedSuccessfullyChild.inc();
        this.statTotalProcessedSuccessfully1minChild.inc();
    }

    @Override
    public void incrSysExceptions(Throwable sysException) {
        this.statTotalSysExceptionsChild.inc();
        this.statTotalSysExceptions1minChild.inc();
        this.addSystemException(sysException);
    }

    @Override
    public void incrUserExceptions(Throwable userException) {
        this.statTotalUserExceptionsChild.inc();
        this.statTotalUserExceptions1minChild.inc();
        this.addUserException(userException);
    }

    @Override
    public void incrSourceExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void incrSinkExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void setLastInvocation(long ts) {
        this.statlastInvocationChild.set(ts);
    }

    @Override
    public void processTimeStart() {
        this.processTimeStart = System.nanoTime();
    }

    @Override
    public void processTimeEnd() {
        if (this.processTimeStart != null) {
            double endTimeMs = ((double)System.nanoTime() - (double)this.processTimeStart.longValue()) / 1000000.0;
            this.statProcessLatencyChild.observe(endTimeMs);
            this.statProcessLatency1minChild.observe(endTimeMs);
        }
    }

    @Override
    public double getTotalProcessedSuccessfully() {
        return this.statTotalProcessedSuccessfullyChild.get();
    }

    @Override
    public double getTotalRecordsReceived() {
        return this.statTotalRecordsReceivedChild.get();
    }

    @Override
    public double getTotalSysExceptions() {
        return this.statTotalSysExceptionsChild.get();
    }

    @Override
    public double getTotalUserExceptions() {
        return this.statTotalUserExceptionsChild.get();
    }

    @Override
    public double getLastInvocation() {
        return this.statlastInvocationChild.get();
    }

    @Override
    public double getAvgProcessLatency() {
        return this.statProcessLatencyChild.get().count <= 0.0 ? 0.0 : this.statProcessLatencyChild.get().sum / this.statProcessLatencyChild.get().count;
    }

    public double getProcessLatency50P() {
        return (Double)this.statProcessLatencyChild.get().quantiles.get(0.5);
    }

    public double getProcessLatency90P() {
        return (Double)this.statProcessLatencyChild.get().quantiles.get(0.9);
    }

    public double getProcessLatency99P() {
        return (Double)this.statProcessLatencyChild.get().quantiles.get(0.99);
    }

    public double getProcessLatency99_9P() {
        return (Double)this.statProcessLatencyChild.get().quantiles.get(0.999);
    }

    @Override
    public double getTotalProcessedSuccessfully1min() {
        return this.statTotalProcessedSuccessfully1minChild.get();
    }

    @Override
    public double getTotalRecordsReceived1min() {
        return this.statTotalRecordsReceivedChild1min.get();
    }

    @Override
    public double getTotalSysExceptions1min() {
        return this.statTotalSysExceptions1minChild.get();
    }

    @Override
    public double getTotalUserExceptions1min() {
        return this.statTotalUserExceptions1minChild.get();
    }

    @Override
    public double getAvgProcessLatency1min() {
        return this.statProcessLatency1minChild.get().count <= 0.0 ? 0.0 : this.statProcessLatency1minChild.get().sum / this.statProcessLatency1minChild.get().count;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSourceExceptions() {
        return this.emptyQueue;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSinkExceptions() {
        return this.emptyQueue;
    }

    public double getProcessLatency50P1min() {
        return (Double)this.statProcessLatency1minChild.get().quantiles.get(0.5);
    }

    public double getProcessLatency90P1min() {
        return (Double)this.statProcessLatency1minChild.get().quantiles.get(0.9);
    }

    public double getProcessLatency99P1min() {
        return (Double)this.statProcessLatency1minChild.get().quantiles.get(0.99);
    }

    public double getProcessLatency99_9P1min() {
        return (Double)this.statProcessLatency1minChild.get().quantiles.get(0.999);
    }

    @Override
    public void reset() {
        this.statTotalProcessedSuccessfully1min.clear();
        this.statTotalProcessedSuccessfully1minChild = (Counter.Child)this.statTotalProcessedSuccessfully1min.labels(this.metricsLabels);
        this.statTotalSysExceptions1min.clear();
        this.statTotalSysExceptions1minChild = (Counter.Child)this.statTotalSysExceptions1min.labels(this.metricsLabels);
        this.statTotalUserExceptions1min.clear();
        this.statTotalUserExceptions1minChild = (Counter.Child)this.statTotalUserExceptions1min.labels(this.metricsLabels);
        this.statProcessLatency1min.clear();
        this.statProcessLatency1minChild = (Summary.Child)this.statProcessLatency1min.labels(this.metricsLabels);
        this.statTotalRecordsReceived1min.clear();
        this.statTotalRecordsReceivedChild1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(this.metricsLabels);
    }

    @Generated
    public Counter getStatTotalProcessedSuccessfully() {
        return this.statTotalProcessedSuccessfully;
    }

    @Generated
    public Counter getStatTotalSysExceptions() {
        return this.statTotalSysExceptions;
    }

    @Generated
    public Counter getStatTotalUserExceptions() {
        return this.statTotalUserExceptions;
    }

    @Generated
    public Summary getStatProcessLatency() {
        return this.statProcessLatency;
    }

    @Generated
    public Gauge getStatlastInvocation() {
        return this.statlastInvocation;
    }

    @Generated
    public Counter getStatTotalRecordsReceived() {
        return this.statTotalRecordsReceived;
    }

    @Generated
    public Counter getStatTotalProcessedSuccessfully1min() {
        return this.statTotalProcessedSuccessfully1min;
    }

    @Generated
    public Counter getStatTotalSysExceptions1min() {
        return this.statTotalSysExceptions1min;
    }

    @Generated
    public Counter getStatTotalUserExceptions1min() {
        return this.statTotalUserExceptions1min;
    }

    @Generated
    public Summary getStatProcessLatency1min() {
        return this.statProcessLatency1min;
    }

    @Generated
    public Counter getStatTotalRecordsReceived1min() {
        return this.statTotalRecordsReceived1min;
    }

    @Generated
    public Gauge getUserExceptions() {
        return this.userExceptions;
    }

    @Generated
    public Gauge getSysExceptions() {
        return this.sysExceptions;
    }

    @Generated
    public Gauge getSourceExceptions() {
        return this.sourceExceptions;
    }

    @Generated
    public Gauge getSinkExceptions() {
        return this.sinkExceptions;
    }

    @Generated
    public Counter.Child getStatTotalProcessedSuccessfullyChild() {
        return this.statTotalProcessedSuccessfullyChild;
    }

    @Generated
    public Counter.Child getStatTotalSysExceptionsChild() {
        return this.statTotalSysExceptionsChild;
    }

    @Generated
    public Counter.Child getStatTotalUserExceptionsChild() {
        return this.statTotalUserExceptionsChild;
    }

    @Generated
    public Summary.Child getStatProcessLatencyChild() {
        return this.statProcessLatencyChild;
    }

    @Generated
    public Gauge.Child getStatlastInvocationChild() {
        return this.statlastInvocationChild;
    }

    @Generated
    public Counter.Child getStatTotalRecordsReceivedChild() {
        return this.statTotalRecordsReceivedChild;
    }

    @Generated
    public Counter.Child getStatTotalProcessedSuccessfully1minChild() {
        return this.statTotalProcessedSuccessfully1minChild;
    }

    @Generated
    public Counter.Child getStatTotalSysExceptions1minChild() {
        return this.statTotalSysExceptions1minChild;
    }

    @Generated
    public Counter.Child getStatTotalUserExceptions1minChild() {
        return this.statTotalUserExceptions1minChild;
    }

    @Generated
    public Summary.Child getStatProcessLatency1minChild() {
        return this.statProcessLatency1minChild;
    }

    @Generated
    public Counter.Child getStatTotalRecordsReceivedChild1min() {
        return this.statTotalRecordsReceivedChild1min;
    }

    @Generated
    public RateLimiter getUserExceptionRateLimiter() {
        return this.userExceptionRateLimiter;
    }

    @Generated
    public RateLimiter getSysExceptionRateLimiter() {
        return this.sysExceptionRateLimiter;
    }

    @Generated
    public Long getProcessTimeStart() {
        return this.processTimeStart;
    }

    @Generated
    public void setStatTotalProcessedSuccessfully1minChild(Counter.Child statTotalProcessedSuccessfully1minChild) {
        this.statTotalProcessedSuccessfully1minChild = statTotalProcessedSuccessfully1minChild;
    }

    @Generated
    public void setStatTotalSysExceptions1minChild(Counter.Child statTotalSysExceptions1minChild) {
        this.statTotalSysExceptions1minChild = statTotalSysExceptions1minChild;
    }

    @Generated
    public void setStatTotalUserExceptions1minChild(Counter.Child statTotalUserExceptions1minChild) {
        this.statTotalUserExceptions1minChild = statTotalUserExceptions1minChild;
    }

    @Generated
    public void setStatProcessLatency1minChild(Summary.Child statProcessLatency1minChild) {
        this.statProcessLatency1minChild = statProcessLatency1minChild;
    }

    @Generated
    public void setStatTotalRecordsReceivedChild1min(Counter.Child statTotalRecordsReceivedChild1min) {
        this.statTotalRecordsReceivedChild1min = statTotalRecordsReceivedChild1min;
    }

    @Generated
    public void setLatestUserExceptions(EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestUserExceptions) {
        this.latestUserExceptions = latestUserExceptions;
    }

    @Generated
    public void setLatestSystemExceptions(EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSystemExceptions) {
        this.latestSystemExceptions = latestSystemExceptions;
    }

    @Generated
    public void setProcessTimeStart(Long processTimeStart) {
        this.processTimeStart = processTimeStart;
    }

    @Override
    @Generated
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestUserExceptions() {
        return this.latestUserExceptions;
    }

    @Override
    @Generated
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSystemExceptions() {
        return this.latestSystemExceptions;
    }
}

