/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCounted;
import org.apache.pulsar.functions.runtime.shaded.javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SegmentedLongArray
implements AutoCloseable {
    private static final int SIZE_OF_LONG = 8;
    private static final int MAX_SEGMENT_SIZE = 0x200000;
    private final List<ByteBuf> buffers = new ArrayList<ByteBuf>();
    private final long initialCapacity;
    private long capacity;

    public SegmentedLongArray(long initialCapacity) {
        long remainingToAdd = initialCapacity;
        int sizeToAdd = (int)Math.min(remainingToAdd, 0x200000L);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(sizeToAdd * 8);
        buffer.writerIndex(sizeToAdd * 8);
        this.buffers.add(buffer);
        remainingToAdd -= (long)sizeToAdd;
        while (remainingToAdd > 0L) {
            buffer = PooledByteBufAllocator.DEFAULT.directBuffer(0x1000000);
            buffer.writerIndex(0x1000000);
            this.buffers.add(buffer);
            remainingToAdd -= 0x200000L;
        }
        this.capacity = this.initialCapacity = initialCapacity;
    }

    public void writeLong(long offset, long value) {
        int bufferIdx = (int)(offset / 0x200000L);
        int internalIdx = (int)(offset % 0x200000L);
        this.buffers.get(bufferIdx).setLong(internalIdx * 8, value);
    }

    public long readLong(long offset) {
        int bufferIdx = (int)(offset / 0x200000L);
        int internalIdx = (int)(offset % 0x200000L);
        return this.buffers.get(bufferIdx).getLong(internalIdx * 8);
    }

    public void increaseCapacity() {
        if (this.capacity < 0x200000L) {
            this.capacity += this.capacity <= 256L ? this.capacity : this.capacity / 2L;
            this.capacity = Math.min(this.capacity, 0x200000L);
            this.buffers.get(0).capacity((int)this.capacity * 8);
            this.buffers.get(0).writerIndex((int)this.capacity * 8);
        } else {
            int bufferSize = 0x1000000;
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(bufferSize, bufferSize);
            buffer.writerIndex(bufferSize);
            this.buffers.add(buffer);
            this.capacity += 0x200000L;
        }
    }

    public void shrink(long newCapacity) {
        long sizeToReduce;
        if (newCapacity >= this.capacity || newCapacity < this.initialCapacity) {
            return;
        }
        for (sizeToReduce = this.capacity - newCapacity; sizeToReduce >= 0x200000L && this.buffers.size() > 1; sizeToReduce -= 0x200000L) {
            ByteBuf b = this.buffers.remove(this.buffers.size() - 1);
            b.release();
            this.capacity -= 0x200000L;
        }
        if (this.buffers.size() == 1 && sizeToReduce > 0L) {
            this.capacity -= sizeToReduce;
            ByteBuf oldBuffer = this.buffers.get(0);
            ByteBuf newBuffer = PooledByteBufAllocator.DEFAULT.directBuffer((int)this.capacity * 8);
            oldBuffer.getBytes(0, newBuffer, (int)this.capacity * 8);
            oldBuffer.release();
            this.buffers.set(0, newBuffer);
        }
    }

    @Override
    public void close() {
        this.buffers.forEach(ReferenceCounted::release);
    }

    public long bytesCapacity() {
        return this.capacity * 8L;
    }

    @Generated
    public long getInitialCapacity() {
        return this.initialCapacity;
    }

    @Generated
    public long getCapacity() {
        return this.capacity;
    }
}

