/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.cache.CacheLoader;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.cache.LoadingCache;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.UncheckedExecutionException;

public class NamespaceName
implements ServiceUnitId {
    private final String namespace;
    private final String tenant;
    private final String cluster;
    private final String localName;
    private static final LoadingCache<String, NamespaceName> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<String, NamespaceName>(){

        @Override
        public NamespaceName load(String name) throws Exception {
            return new NamespaceName(name);
        }
    });
    public static final NamespaceName SYSTEM_NAMESPACE = NamespaceName.get("pulsar/system");

    public static NamespaceName get(String tenant, String namespace) {
        NamespaceName.validateNamespaceName(tenant, namespace);
        return NamespaceName.get(tenant + '/' + namespace);
    }

    public static NamespaceName get(String tenant, String cluster, String namespace) {
        NamespaceName.validateNamespaceName(tenant, cluster, namespace);
        return NamespaceName.get(tenant + '/' + cluster + '/' + namespace);
    }

    public static NamespaceName get(String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("Invalid null namespace: " + namespace);
        }
        try {
            return cache.get(namespace);
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
        catch (UncheckedExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public static Optional<NamespaceName> getIfValid(String namespace) {
        NamespaceName ns = (NamespaceName)cache.getIfPresent(namespace);
        if (ns != null) {
            return Optional.of(ns);
        }
        if (namespace.length() == 0) {
            return Optional.empty();
        }
        if (!namespace.contains("/")) {
            return Optional.empty();
        }
        return Optional.of(NamespaceName.get(namespace));
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    private NamespaceName(String namespace) {
        block4: {
            try {
                String[] parts = namespace.split("/");
                if (parts.length == 2) {
                    NamespaceName.validateNamespaceName(parts[0], parts[1]);
                    this.tenant = parts[0];
                    this.cluster = null;
                    this.localName = parts[1];
                    break block4;
                }
                if (parts.length == 3) {
                    NamespaceName.validateNamespaceName(parts[0], parts[1], parts[2]);
                    this.tenant = parts[0];
                    this.cluster = parts[1];
                    this.localName = parts[2];
                    break block4;
                }
                throw new IllegalArgumentException("Invalid namespace format. namespace: " + namespace);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new IllegalArgumentException("Invalid namespace format. expected <tenant>/<namespace> or <tenant>/<cluster>/<namespace> but got: " + namespace, e);
            }
        }
        this.namespace = namespace;
    }

    public String getTenant() {
        return this.tenant;
    }

    @Deprecated
    public String getCluster() {
        return this.cluster;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isGlobal() {
        return this.cluster == null || "global".equalsIgnoreCase(this.cluster);
    }

    public String getPersistentTopicName(String localTopic) {
        return this.getTopicName(TopicDomain.persistent, localTopic);
    }

    String getTopicName(TopicDomain domain, String topic) {
        if (domain == null) {
            throw new IllegalArgumentException("invalid null domain");
        }
        NamedEntity.checkName(topic);
        return String.format("%s://%s/%s", domain.toString(), this.namespace, topic);
    }

    @Override
    public String toString() {
        return this.namespace;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceName) {
            NamespaceName other = (NamespaceName)obj;
            return Objects.equals(this.namespace, other.namespace);
        }
        return false;
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public static void validateNamespaceName(String tenant, String namespace) {
        if (tenant == null || tenant.isEmpty() || namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid namespace format. namespace: %s/%s", tenant, namespace));
        }
        NamedEntity.checkName(tenant);
        NamedEntity.checkName(namespace);
    }

    public static void validateNamespaceName(String tenant, String cluster, String namespace) {
        if (tenant == null || tenant.isEmpty() || cluster == null || cluster.isEmpty() || namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid namespace format. namespace: %s/%s/%s", tenant, cluster, namespace));
        }
        NamedEntity.checkName(tenant);
        NamedEntity.checkName(cluster);
        NamedEntity.checkName(namespace);
    }

    @Override
    public NamespaceName getNamespaceObject() {
        return this;
    }

    @Override
    public boolean includes(TopicName topicName) {
        return this.equals(topicName.getNamespaceObject());
    }

    public boolean isV2() {
        return this.cluster == null;
    }
}

