/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Optional;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;

public class NativeAvroBytesSchema<T>
implements Schema<byte[]> {
    private Schema<T> schema;
    private org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema nativeSchema;

    public NativeAvroBytesSchema(org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema schema) {
        this.setSchema(schema);
    }

    public NativeAvroBytesSchema(Object schema) {
        this(NativeAvroBytesSchema.validateSchema(schema));
    }

    public void setSchema(org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema schema) {
        SchemaDefinition schemaDefinition = SchemaDefinition.builder().withJsonDef(schema.toString(false)).build();
        this.nativeSchema = schema;
        this.schema = AvroSchema.of(schemaDefinition);
    }

    public boolean schemaInitialized() {
        return this.schema != null;
    }

    private static org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema validateSchema(Object schema) {
        if (!(schema instanceof org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema)) {
            throw new IllegalArgumentException("The input schema is not of type 'org.apache.avro.Schema'.");
        }
        return (org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema)schema;
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(this.schemaInitialized(), "Schema is not initialized before used");
    }

    @Override
    public byte[] encode(byte[] message) {
        this.ensureSchemaInitialized();
        return message;
    }

    @Override
    public byte[] decode(byte[] bytes, byte[] schemaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }

    @Override
    public Optional<Object> getNativeSchema() {
        return Optional.of(this.nativeSchema);
    }

    @Override
    public Schema<byte[]> clone() {
        return new NativeAvroBytesSchema<T>(this.nativeSchema);
    }
}

