/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.util.concurrent.CompletableFuture;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.util.FutureUtil;

public interface AuthenticationState {
    public String getAuthRole() throws AuthenticationException;

    @Deprecated
    public AuthData authenticate(AuthData var1) throws AuthenticationException;

    default public CompletableFuture<AuthData> authenticateAsync(AuthData authData) {
        try {
            AuthData result = this.authenticate(authData);
            if (this.isComplete()) {
                return CompletableFuture.completedFuture(null);
            }
            return result != null ? CompletableFuture.completedFuture(result) : CompletableFuture.completedFuture(AuthData.of(new byte[0]));
        }
        catch (Exception e) {
            return FutureUtil.failedFuture(e);
        }
    }

    public AuthenticationDataSource getAuthDataSource();

    @Deprecated
    public boolean isComplete();

    default public long getStateId() {
        return -1L;
    }

    default public boolean isExpired() {
        return false;
    }

    default public AuthData refreshAuthentication() throws AuthenticationException {
        return AuthData.REFRESH_AUTH_DATA;
    }
}

