/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.instance.AbstractSinkRecord;
import org.apache.pulsar.functions.source.PulsarRecord;

public class SinkRecord<T>
extends AbstractSinkRecord<T> {
    private final Record<T> sourceRecord;
    private final T value;

    public SinkRecord(Record<T> sourceRecord, T value) {
        super(sourceRecord);
        this.sourceRecord = sourceRecord;
        this.value = value;
    }

    public Optional<String> getKey() {
        return this.sourceRecord.getKey();
    }

    public T getValue() {
        return this.value;
    }

    public Optional<String> getPartitionId() {
        return this.sourceRecord.getPartitionId();
    }

    public Optional<Integer> getPartitionIndex() {
        return this.sourceRecord.getPartitionIndex();
    }

    public Optional<Long> getRecordSequence() {
        return this.sourceRecord.getRecordSequence();
    }

    public Map<String, String> getProperties() {
        return this.sourceRecord.getProperties();
    }

    public Optional<String> getDestinationTopic() {
        return this.sourceRecord.getDestinationTopic();
    }

    public Schema<T> getSchema() {
        return SinkRecord.getRecordSchema(this.sourceRecord);
    }

    public Optional<Long> getEventTime() {
        return this.sourceRecord.getEventTime();
    }

    public Optional<Message<T>> getMessage() {
        return this.sourceRecord.getMessage();
    }

    @Override
    public boolean shouldAlwaysSetMessageProperties() {
        return false;
    }

    @Override
    public boolean shouldSetSchema() {
        return !(this.sourceRecord instanceof PulsarRecord);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkRecord)) {
            return false;
        }
        SinkRecord other = (SinkRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Record<T> this$sourceRecord = this.sourceRecord;
        Record<T> other$sourceRecord = other.sourceRecord;
        if (this$sourceRecord == null ? other$sourceRecord != null : !this$sourceRecord.equals(other$sourceRecord)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SinkRecord;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Record<T> $sourceRecord = this.sourceRecord;
        result = result * 59 + ($sourceRecord == null ? 43 : $sourceRecord.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SinkRecord(sourceRecord=" + this.sourceRecord + ", value=" + this.getValue() + ")";
    }
}

