/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.policies.data.loadbalancer;

import lombok.Generated;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;

public class TimeAverageMessageData
implements Comparable<TimeAverageMessageData> {
    private int maxSamples;
    private int numSamples;
    private double msgThroughputIn;
    private double msgThroughputOut;
    private double msgRateIn;
    private double msgRateOut;
    private static final double throughputDifferenceThreshold = 100000.0;
    private static final double msgRateDifferenceThreshold = 100.0;

    public TimeAverageMessageData() {
    }

    public TimeAverageMessageData(int maxSamples) {
        this.maxSamples = maxSamples;
    }

    public TimeAverageMessageData(int maxSamples, NamespaceBundleStats defaultStats) {
        this.maxSamples = maxSamples;
        this.msgThroughputIn = defaultStats.msgThroughputIn;
        this.msgThroughputOut = defaultStats.msgThroughputOut;
        this.msgRateIn = defaultStats.msgRateIn;
        this.msgRateOut = defaultStats.msgRateOut;
    }

    public void update(double newMsgThroughputIn, double newMsgThroughputOut, double newMsgRateIn, double newMsgRateOut) {
        this.numSamples = Math.min(this.numSamples + 1, this.maxSamples);
        this.msgThroughputIn = this.getUpdatedValue(this.msgThroughputIn, newMsgThroughputIn);
        this.msgThroughputOut = this.getUpdatedValue(this.msgThroughputOut, newMsgThroughputOut);
        this.msgRateIn = this.getUpdatedValue(this.msgRateIn, newMsgRateIn);
        this.msgRateOut = this.getUpdatedValue(this.msgRateOut, newMsgRateOut);
    }

    public void update(NamespaceBundleStats newSample) {
        this.update(newSample.msgThroughputIn, newSample.msgThroughputOut, newSample.msgRateIn, newSample.msgRateOut);
    }

    private double getUpdatedValue(double oldAverage, double newSample) {
        return ((double)(this.numSamples - 1) * oldAverage + newSample) / (double)this.numSamples;
    }

    public int getMaxSamples() {
        return this.maxSamples;
    }

    public void setMaxSamples(int maxSamples) {
        this.maxSamples = maxSamples;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    public void setMsgThroughputIn(double msgThroughputIn) {
        this.msgThroughputIn = msgThroughputIn;
    }

    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public double totalMsgRate() {
        return this.msgRateIn + this.msgRateOut;
    }

    public double totalMsgThroughput() {
        return this.msgThroughputIn + this.msgThroughputOut;
    }

    @Override
    public int compareTo(TimeAverageMessageData other) {
        int result = this.compareByBandwidthIn(other);
        if (result == 0) {
            result = this.compareByBandwidthOut(other);
        }
        if (result == 0) {
            result = this.compareByMsgRate(other);
        }
        return result;
    }

    public int compareByMsgRate(TimeAverageMessageData other) {
        double thisMsgRate = this.msgRateIn + this.msgRateOut;
        double otherMsgRate = other.msgRateIn + other.msgRateOut;
        if (Math.abs(thisMsgRate - otherMsgRate) > 100.0) {
            return Double.compare(thisMsgRate, otherMsgRate);
        }
        return 0;
    }

    public int compareByBandwidthIn(TimeAverageMessageData other) {
        if (Math.abs(this.msgThroughputIn - other.msgThroughputIn) > 100000.0) {
            return Double.compare(this.msgThroughputIn, other.msgThroughputIn);
        }
        return 0;
    }

    public int compareByBandwidthOut(TimeAverageMessageData other) {
        if (Math.abs(this.msgThroughputOut - other.msgThroughputOut) > 100000.0) {
            return Double.compare(this.msgThroughputOut, other.msgThroughputOut);
        }
        return 0;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeAverageMessageData)) {
            return false;
        }
        TimeAverageMessageData other = (TimeAverageMessageData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSamples() != other.getMaxSamples()) {
            return false;
        }
        if (this.getNumSamples() != other.getNumSamples()) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputIn(), other.getMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateIn(), other.getMsgRateIn()) != 0) {
            return false;
        }
        return Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeAverageMessageData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxSamples();
        result = result * 59 + this.getNumSamples();
        long $msgThroughputIn = Double.doubleToLongBits(this.getMsgThroughputIn());
        result = result * 59 + (int)($msgThroughputIn >>> 32 ^ $msgThroughputIn);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $msgRateIn = Double.doubleToLongBits(this.getMsgRateIn());
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        return result;
    }
}

