/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.semaphore;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.semaphore.AsyncDualMemoryLimiter;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.shade.io.netty.util.concurrent.Future;
import org.apache.pulsar.shade.io.netty.util.concurrent.GenericFutureListener;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;

public final class AsyncDualMemoryLimiterUtil {
    public static <T> CompletableFuture<T> withPermitsFuture(CompletableFuture<AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit> permitsFuture, Function<AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit, CompletableFuture<T>> function, Function<Throwable, CompletableFuture<T>> permitAcquireErrorHandler, Consumer<AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit> releaser) {
        return ((CompletableFuture)permitsFuture.handle((permits, permitAcquireError) -> Pair.of(permits, permitAcquireError))).thenCompose(permitsAndError -> {
            if (permitsAndError.getRight() != null) {
                return (CompletionStage)permitAcquireErrorHandler.apply((Throwable)permitsAndError.getRight());
            }
            AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit permits = (AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit)permitsAndError.getLeft();
            try {
                return ((CompletableFuture)function.apply(permits)).whenComplete((__, ___) -> releaser.accept(permits));
            }
            catch (Throwable t) {
                releaser.accept(permits);
                throw t;
            }
        });
    }

    public static CompletableFuture<Void> acquireDirectMemoryPermitsAndWriteAndFlush(ChannelHandlerContext ctx, AsyncDualMemoryLimiter dualMemoryLimiter, BooleanSupplier isCancelled, BaseCommand command, Function<Throwable, CompletableFuture<Void>> permitAcquireErrorHandler) {
        int serializedSize = command.getSerializedSize();
        return ((CompletableFuture)dualMemoryLimiter.acquire(serializedSize, AsyncDualMemoryLimiter.LimitType.DIRECT_MEMORY, isCancelled).handle((permits, t) -> {
            if (t != null) {
                return (CompletableFuture)permitAcquireErrorHandler.apply((Throwable)t);
            }
            try {
                ByteBuf outBuf = Commands.serializeWithPrecalculatedSerializedSize(command, serializedSize);
                ctx.writeAndFlush(outBuf).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> dualMemoryLimiter.release((AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit)permits)));
            }
            catch (Throwable e) {
                dualMemoryLimiter.release((AsyncDualMemoryLimiter.AsyncDualMemoryLimiterPermit)permits);
                throw e;
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(Function.identity());
    }

    @Generated
    private AsyncDualMemoryLimiterUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

