/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.prometheus.client;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.DoubleAdder;
import org.apache.pulsar.shade.io.prometheus.client.Environment;
import org.apache.pulsar.shade.io.prometheus.client.SimpleCollector;
import org.apache.pulsar.shade.io.prometheus.client.SimpleTimer;
import org.apache.pulsar.shade.io.prometheus.client.exemplars.Exemplar;
import org.apache.pulsar.shade.io.prometheus.client.exemplars.ExemplarConfig;
import org.apache.pulsar.shade.io.prometheus.client.exemplars.HistogramExemplarSampler;

public class Histogram
extends SimpleCollector<Child>
implements Collector.Describable {
    private final double[] buckets;
    private final Boolean exemplarsEnabled;
    private final HistogramExemplarSampler exemplarSampler;

    Histogram(Builder b) {
        super(b);
        this.exemplarsEnabled = b.exemplarsEnabled;
        this.exemplarSampler = b.exemplarSampler;
        this.buckets = b.buckets;
        this.initializeNoLabelsChild();
    }

    public static Builder build(String name, String help) {
        return (Builder)((Builder)new Builder().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child(this.buckets, this.exemplarsEnabled, this.exemplarSampler);
    }

    public void observe(double amt) {
        ((Child)this.noLabelsChild).observe(amt);
    }

    public void observeWithExemplar(double amt, String ... exemplarLabels) {
        ((Child)this.noLabelsChild).observeWithExemplar(amt, exemplarLabels);
    }

    public void observeWithExemplar(double amt, Map<String, String> exemplarLabels) {
        ((Child)this.noLabelsChild).observeWithExemplar(amt, exemplarLabels);
    }

    public Timer startTimer() {
        return ((Child)this.noLabelsChild).startTimer();
    }

    public double time(Runnable timeable) {
        return ((Child)this.noLabelsChild).time(timeable);
    }

    public double timeWithExemplar(Runnable timeable, String ... exemplarLabels) {
        return ((Child)this.noLabelsChild).timeWithExemplar(timeable, exemplarLabels);
    }

    public double timeWithExemplar(Runnable timeable, Map<String, String> exemplarLabels) {
        return ((Child)this.noLabelsChild).timeWithExemplar(timeable, exemplarLabels);
    }

    public <E> E time(Callable<E> timeable) {
        return ((Child)this.noLabelsChild).time(timeable);
    }

    public <E> E timeWithExemplar(Callable<E> timeable, String ... exemplarLabels) {
        return ((Child)this.noLabelsChild).timeWithExemplar(timeable, exemplarLabels);
    }

    public <E> E timeWithExemplar(Callable<E> timeable, Map<String, String> exemplarLabels) {
        return ((Child)this.noLabelsChild).timeWithExemplar(timeable, exemplarLabels);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            Child.Value v = ((Child)c.getValue()).get();
            ArrayList<String> labelNamesWithLe = new ArrayList<String>(this.labelNames);
            labelNamesWithLe.add("le");
            for (int i = 0; i < v.buckets.length; ++i) {
                ArrayList<String> labelValuesWithLe = new ArrayList<String>((Collection)c.getKey());
                labelValuesWithLe.add(Histogram.doubleToGoString(this.buckets[i]));
                samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_bucket", labelNamesWithLe, labelValuesWithLe, v.buckets[i], v.exemplars[i]));
            }
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_count", this.labelNames, (List)c.getKey(), v.buckets[this.buckets.length - 1]));
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_sum", this.labelNames, (List)c.getKey(), v.sum));
            if (!Environment.includeCreatedSeries()) continue;
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_created", this.labelNames, (List)c.getKey(), (double)v.created / 1000.0));
        }
        return this.familySamplesList(Collector.Type.HISTOGRAM, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.fullname, Collector.Type.HISTOGRAM, this.help, Collections.<Collector.MetricFamilySamples.Sample>emptyList()));
    }

    double[] getBuckets() {
        return this.buckets;
    }

    public static class Child {
        private final ArrayList<AtomicReference<Exemplar>> exemplars;
        private final Boolean exemplarsEnabled;
        private final HistogramExemplarSampler exemplarSampler;
        private final double[] upperBounds;
        private final DoubleAdder[] cumulativeCounts;
        private final DoubleAdder sum = new DoubleAdder();
        private final long created = System.currentTimeMillis();

        public double time(Runnable timeable) {
            return this.timeWithExemplar(timeable, (String[])null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double timeWithExemplar(Runnable timeable, String ... exemplarLabels) {
            double elapsed;
            Timer timer = this.startTimer();
            try {
                timeable.run();
            }
            finally {
                elapsed = timer.observeDurationWithExemplar(exemplarLabels);
            }
            return elapsed;
        }

        public double timeWithExemplar(Runnable timeable, Map<String, String> exemplarLabels) {
            return this.timeWithExemplar(timeable, Exemplar.mapToArray(exemplarLabels));
        }

        public <E> E time(Callable<E> timeable) {
            return this.timeWithExemplar(timeable, (String[])null);
        }

        public <E> E timeWithExemplar(Callable<E> timeable, String ... exemplarLabels) {
            Timer timer = this.startTimer();
            try {
                E e = timeable.call();
                return e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                timer.observeDurationWithExemplar(exemplarLabels);
            }
        }

        public <E> E timeWithExemplar(Callable<E> timeable, Map<String, String> exemplarLabels) {
            return this.timeWithExemplar(timeable, Exemplar.mapToArray(exemplarLabels));
        }

        private Child(double[] buckets, Boolean exemplarsEnabled, HistogramExemplarSampler exemplarSampler) {
            this.upperBounds = buckets;
            this.exemplarsEnabled = exemplarsEnabled;
            this.exemplarSampler = exemplarSampler;
            this.exemplars = new ArrayList(buckets.length);
            this.cumulativeCounts = new DoubleAdder[buckets.length];
            for (int i = 0; i < buckets.length; ++i) {
                this.cumulativeCounts[i] = new DoubleAdder();
                this.exemplars.add(new AtomicReference());
            }
        }

        public void observe(double amt) {
            this.observeWithExemplar(amt, (String[])null);
        }

        public void observeWithExemplar(double amt, String ... exemplarLabels) {
            Exemplar exemplar = exemplarLabels == null ? null : new Exemplar(amt, (Long)System.currentTimeMillis(), exemplarLabels);
            for (int i = 0; i < this.upperBounds.length; ++i) {
                if (!(amt <= this.upperBounds[i])) continue;
                this.cumulativeCounts[i].add(1.0);
                this.updateExemplar(amt, i, exemplar);
                break;
            }
            this.sum.add(amt);
        }

        public void observeWithExemplar(double amt, Map<String, String> exemplarLabels) {
            this.observeWithExemplar(amt, Exemplar.mapToArray(exemplarLabels));
        }

        private void updateExemplar(double amt, int i, Exemplar userProvidedExemplar) {
            Exemplar next;
            Exemplar prev;
            AtomicReference<Exemplar> exemplar = this.exemplars.get(i);
            double bucketFrom = i == 0 ? Double.NEGATIVE_INFINITY : this.upperBounds[i - 1];
            double bucketTo = this.upperBounds[i];
            do {
                prev = exemplar.get();
                next = userProvidedExemplar != null ? userProvidedExemplar : this.sampleNextExemplar(amt, bucketFrom, bucketTo, prev);
                if (next != null && next != prev) continue;
                return;
            } while (!exemplar.compareAndSet(prev, next));
        }

        private Exemplar sampleNextExemplar(double amt, double bucketFrom, double bucketTo, Exemplar prev) {
            HistogramExemplarSampler exemplarSampler;
            if (Boolean.FALSE.equals(this.exemplarsEnabled)) {
                return null;
            }
            if (this.exemplarSampler != null) {
                return this.exemplarSampler.sample(amt, bucketFrom, bucketTo, prev);
            }
            if ((Boolean.TRUE.equals(this.exemplarsEnabled) || ExemplarConfig.isExemplarsEnabled()) && (exemplarSampler = ExemplarConfig.getHistogramExemplarSampler()) != null) {
                return exemplarSampler.sample(amt, bucketFrom, bucketTo, prev);
            }
            return null;
        }

        public Timer startTimer() {
            return new Timer(this, SimpleTimer.defaultTimeProvider.nanoTime());
        }

        public Value get() {
            double[] buckets = new double[this.cumulativeCounts.length];
            Exemplar[] exemplars = new Exemplar[this.cumulativeCounts.length];
            double acc = 0.0;
            for (int i = 0; i < this.cumulativeCounts.length; ++i) {
                buckets[i] = acc += this.cumulativeCounts[i].sum();
                exemplars[i] = this.exemplars.get(i).get();
            }
            return new Value(this.sum.sum(), buckets, exemplars, this.created);
        }

        public static class Value {
            public final double sum;
            public final double[] buckets;
            public final Exemplar[] exemplars;
            public final long created;

            public Value(double sum, double[] buckets, Exemplar[] exemplars, long created) {
                this.sum = sum;
                this.buckets = buckets;
                this.exemplars = exemplars;
                this.created = created;
            }
        }
    }

    public static class Timer
    implements Closeable {
        private final Child child;
        private final long start;

        private Timer(Child child, long start) {
            this.child = child;
            this.start = start;
        }

        public double observeDuration() {
            return this.observeDurationWithExemplar((String[])null);
        }

        public double observeDurationWithExemplar(String ... exemplarLabels) {
            double elapsed = SimpleTimer.elapsedSecondsFromNanos(this.start, SimpleTimer.defaultTimeProvider.nanoTime());
            this.child.observeWithExemplar(elapsed, exemplarLabels);
            return elapsed;
        }

        public double observeDurationWithExemplar(Map<String, String> exemplarLabels) {
            return this.observeDurationWithExemplar(Exemplar.mapToArray(exemplarLabels));
        }

        @Override
        public void close() {
            this.observeDuration();
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Histogram> {
        private Boolean exemplarsEnabled = null;
        private HistogramExemplarSampler exemplarSampler = null;
        private double[] buckets = new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0};

        @Override
        public Histogram create() {
            for (int i = 0; i < this.buckets.length - 1; ++i) {
                if (!(this.buckets[i] >= this.buckets[i + 1])) continue;
                throw new IllegalStateException("Histogram buckets must be in increasing order: " + this.buckets[i] + " >= " + this.buckets[i + 1]);
            }
            if (this.buckets.length == 0) {
                throw new IllegalStateException("Histogram must have at least one bucket.");
            }
            for (String label : this.labelNames) {
                if (!label.equals("le")) continue;
                throw new IllegalStateException("Histogram cannot have a label named 'le'.");
            }
            if (this.buckets[this.buckets.length - 1] != Double.POSITIVE_INFINITY) {
                double[] tmp = new double[this.buckets.length + 1];
                System.arraycopy(this.buckets, 0, tmp, 0, this.buckets.length);
                tmp[this.buckets.length] = Double.POSITIVE_INFINITY;
                this.buckets = tmp;
            }
            this.dontInitializeNoLabelsChild = true;
            return new Histogram(this);
        }

        public Builder buckets(double ... buckets) {
            this.buckets = buckets;
            return this;
        }

        public Builder linearBuckets(double start, double width, int count) {
            this.buckets = new double[count];
            for (int i = 0; i < count; ++i) {
                this.buckets[i] = start + (double)i * width;
            }
            return this;
        }

        public Builder exponentialBuckets(double start, double factor, int count) {
            this.buckets = new double[count];
            for (int i = 0; i < count; ++i) {
                this.buckets[i] = start * Math.pow(factor, i);
            }
            return this;
        }

        public Builder withExemplarSampler(HistogramExemplarSampler exemplarSampler) {
            if (exemplarSampler == null) {
                throw new NullPointerException();
            }
            this.exemplarSampler = exemplarSampler;
            return this.withExemplars();
        }

        public Builder withExemplars() {
            this.exemplarsEnabled = Boolean.TRUE;
            return this;
        }

        public Builder withoutExemplars() {
            this.exemplarsEnabled = Boolean.FALSE;
            return this;
        }
    }
}

