/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.pulsar.common.policies.data.FunctionInstanceStats;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataBaseImpl;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataImpl;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsImpl;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.util.ObjectMapperFactory;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonPropertyOrder(value={"receivedTotal", "processedSuccessfullyTotal", "systemExceptionsTotal", "userExceptionsTotal", "avgProcessLatency", "1min", "lastInvocation", "instances"})
public class FunctionStatsImpl
implements FunctionStats {
    public long receivedTotal;
    public long processedSuccessfullyTotal;
    public long systemExceptionsTotal;
    public long userExceptionsTotal;
    public Double avgProcessLatency;
    @JsonProperty(value="1min")
    public FunctionInstanceStatsDataBaseImpl oneMin = new FunctionInstanceStatsDataBaseImpl();
    public Long lastInvocation;
    public List<FunctionInstanceStatsImpl> instances = new LinkedList<FunctionInstanceStatsImpl>();

    public void addInstance(FunctionInstanceStatsImpl functionInstanceStats) {
        this.instances.add(functionInstanceStats);
    }

    public FunctionStatsImpl calculateOverall() {
        int nonNullInstances = 0;
        int nonNullInstancesOneMin = 0;
        for (FunctionInstanceStats functionInstanceStats : this.instances) {
            FunctionInstanceStatsDataImpl functionInstanceStatsData = (FunctionInstanceStatsDataImpl)functionInstanceStats.getMetrics();
            this.receivedTotal += functionInstanceStatsData.receivedTotal;
            this.processedSuccessfullyTotal += functionInstanceStatsData.processedSuccessfullyTotal;
            this.systemExceptionsTotal += functionInstanceStatsData.systemExceptionsTotal;
            this.userExceptionsTotal += functionInstanceStatsData.userExceptionsTotal;
            if (functionInstanceStatsData.avgProcessLatency != null) {
                if (this.avgProcessLatency == null) {
                    this.avgProcessLatency = 0.0;
                }
                this.avgProcessLatency = this.avgProcessLatency + functionInstanceStatsData.avgProcessLatency;
                ++nonNullInstances;
            }
            this.oneMin.setReceivedTotal(this.oneMin.getReceivedTotal() + functionInstanceStatsData.oneMin.getReceivedTotal());
            this.oneMin.setProcessedSuccessfullyTotal(this.oneMin.getProcessedSuccessfullyTotal() + functionInstanceStatsData.oneMin.getProcessedSuccessfullyTotal());
            this.oneMin.setSystemExceptionsTotal(this.oneMin.getSystemExceptionsTotal() + functionInstanceStatsData.oneMin.getSystemExceptionsTotal());
            this.oneMin.setUserExceptionsTotal(this.oneMin.getUserExceptionsTotal() + functionInstanceStatsData.oneMin.getUserExceptionsTotal());
            if (functionInstanceStatsData.oneMin.getAvgProcessLatency() != null) {
                if (this.oneMin.getAvgProcessLatency() == null) {
                    this.oneMin.setAvgProcessLatency(0.0);
                }
                this.oneMin.setAvgProcessLatency(this.oneMin.getAvgProcessLatency() + functionInstanceStatsData.oneMin.getAvgProcessLatency());
                ++nonNullInstancesOneMin;
            }
            if (functionInstanceStatsData.lastInvocation == null || this.lastInvocation != null && functionInstanceStatsData.lastInvocation <= this.lastInvocation) continue;
            this.lastInvocation = functionInstanceStatsData.lastInvocation;
        }
        this.avgProcessLatency = nonNullInstances > 0 ? Double.valueOf(this.avgProcessLatency / (double)nonNullInstances) : null;
        if (nonNullInstancesOneMin > 0) {
            this.oneMin.setAvgProcessLatency(this.oneMin.getAvgProcessLatency() / (double)nonNullInstancesOneMin);
        } else {
            this.oneMin.setAvgProcessLatency(null);
        }
        return this;
    }

    public static FunctionStatsImpl decode(String json) throws IOException {
        return ObjectMapperFactory.getMapper().reader().readValue(json, FunctionStatsImpl.class);
    }

    @Generated
    public FunctionStatsImpl() {
    }

    @Generated
    public long getReceivedTotal() {
        return this.receivedTotal;
    }

    @Generated
    public long getProcessedSuccessfullyTotal() {
        return this.processedSuccessfullyTotal;
    }

    @Generated
    public long getSystemExceptionsTotal() {
        return this.systemExceptionsTotal;
    }

    @Generated
    public long getUserExceptionsTotal() {
        return this.userExceptionsTotal;
    }

    @Generated
    public Double getAvgProcessLatency() {
        return this.avgProcessLatency;
    }

    @Generated
    public FunctionInstanceStatsDataBaseImpl getOneMin() {
        return this.oneMin;
    }

    @Generated
    public Long getLastInvocation() {
        return this.lastInvocation;
    }

    @Generated
    public List<FunctionInstanceStatsImpl> getInstances() {
        return this.instances;
    }

    @Generated
    public void setReceivedTotal(long receivedTotal) {
        this.receivedTotal = receivedTotal;
    }

    @Generated
    public void setProcessedSuccessfullyTotal(long processedSuccessfullyTotal) {
        this.processedSuccessfullyTotal = processedSuccessfullyTotal;
    }

    @Generated
    public void setSystemExceptionsTotal(long systemExceptionsTotal) {
        this.systemExceptionsTotal = systemExceptionsTotal;
    }

    @Generated
    public void setUserExceptionsTotal(long userExceptionsTotal) {
        this.userExceptionsTotal = userExceptionsTotal;
    }

    @Generated
    public void setAvgProcessLatency(Double avgProcessLatency) {
        this.avgProcessLatency = avgProcessLatency;
    }

    @Generated
    public void setOneMin(FunctionInstanceStatsDataBaseImpl oneMin) {
        this.oneMin = oneMin;
    }

    @Generated
    public void setLastInvocation(Long lastInvocation) {
        this.lastInvocation = lastInvocation;
    }

    @Generated
    public void setInstances(List<FunctionInstanceStatsImpl> instances) {
        this.instances = instances;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionStatsImpl)) {
            return false;
        }
        FunctionStatsImpl other = (FunctionStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReceivedTotal() != other.getReceivedTotal()) {
            return false;
        }
        if (this.getProcessedSuccessfullyTotal() != other.getProcessedSuccessfullyTotal()) {
            return false;
        }
        if (this.getSystemExceptionsTotal() != other.getSystemExceptionsTotal()) {
            return false;
        }
        if (this.getUserExceptionsTotal() != other.getUserExceptionsTotal()) {
            return false;
        }
        Double this$avgProcessLatency = this.getAvgProcessLatency();
        Double other$avgProcessLatency = other.getAvgProcessLatency();
        if (this$avgProcessLatency == null ? other$avgProcessLatency != null : !((Object)this$avgProcessLatency).equals(other$avgProcessLatency)) {
            return false;
        }
        Long this$lastInvocation = this.getLastInvocation();
        Long other$lastInvocation = other.getLastInvocation();
        if (this$lastInvocation == null ? other$lastInvocation != null : !((Object)this$lastInvocation).equals(other$lastInvocation)) {
            return false;
        }
        FunctionInstanceStatsDataBaseImpl this$oneMin = this.getOneMin();
        FunctionInstanceStatsDataBaseImpl other$oneMin = other.getOneMin();
        if (this$oneMin == null ? other$oneMin != null : !((Object)this$oneMin).equals(other$oneMin)) {
            return false;
        }
        List<FunctionInstanceStatsImpl> this$instances = this.getInstances();
        List<FunctionInstanceStatsImpl> other$instances = other.getInstances();
        return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionStatsImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $receivedTotal = this.getReceivedTotal();
        result = result * 59 + (int)($receivedTotal >>> 32 ^ $receivedTotal);
        long $processedSuccessfullyTotal = this.getProcessedSuccessfullyTotal();
        result = result * 59 + (int)($processedSuccessfullyTotal >>> 32 ^ $processedSuccessfullyTotal);
        long $systemExceptionsTotal = this.getSystemExceptionsTotal();
        result = result * 59 + (int)($systemExceptionsTotal >>> 32 ^ $systemExceptionsTotal);
        long $userExceptionsTotal = this.getUserExceptionsTotal();
        result = result * 59 + (int)($userExceptionsTotal >>> 32 ^ $userExceptionsTotal);
        Double $avgProcessLatency = this.getAvgProcessLatency();
        result = result * 59 + ($avgProcessLatency == null ? 43 : ((Object)$avgProcessLatency).hashCode());
        Long $lastInvocation = this.getLastInvocation();
        result = result * 59 + ($lastInvocation == null ? 43 : ((Object)$lastInvocation).hashCode());
        FunctionInstanceStatsDataBaseImpl $oneMin = this.getOneMin();
        result = result * 59 + ($oneMin == null ? 43 : ((Object)$oneMin).hashCode());
        List<FunctionInstanceStatsImpl> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FunctionStatsImpl(receivedTotal=" + this.getReceivedTotal() + ", processedSuccessfullyTotal=" + this.getProcessedSuccessfullyTotal() + ", systemExceptionsTotal=" + this.getSystemExceptionsTotal() + ", userExceptionsTotal=" + this.getUserExceptionsTotal() + ", avgProcessLatency=" + this.getAvgProcessLatency() + ", oneMin=" + this.getOneMin() + ", lastInvocation=" + this.getLastInvocation() + ", instances=" + this.getInstances() + ")";
    }
}

