/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileModifiedTimeUpdater {
    String fileName;
    FileTime lastModifiedTime;
    private static final Logger LOG = LoggerFactory.getLogger(FileModifiedTimeUpdater.class);

    public FileModifiedTimeUpdater(String fileName) {
        this.fileName = fileName;
        this.lastModifiedTime = this.updateLastModifiedTime();
    }

    private FileTime updateLastModifiedTime() {
        if (this.fileName != null) {
            Path p = Paths.get(this.fileName, new String[0]);
            try {
                return Files.getLastModifiedTime(p, new LinkOption[0]);
            }
            catch (IOException e) {
                LOG.error("Unable to fetch lastModified time for file {}: ", (Object)this.fileName, (Object)e);
            }
        }
        return null;
    }

    public boolean checkAndRefresh() {
        FileTime newLastModifiedTime = this.updateLastModifiedTime();
        if (newLastModifiedTime != null && !newLastModifiedTime.equals(this.lastModifiedTime)) {
            this.lastModifiedTime = newLastModifiedTime;
            return true;
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }
}

