/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.url;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataURLStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new DataURLConnection(u);
    }

    static class DataURLConnection
    extends URLConnection {
        private boolean parsed = false;
        private String contentType;
        private byte[] data;
        private URI uri;
        private static final Pattern pattern = Pattern.compile("(?<mimeType>[^;,]+)?(;(?<charset>charset=[^;,]+))?(;(?<base64>base64))?,(?<data>.+)", 32);

        protected DataURLConnection(URL url) {
            super(url);
            try {
                this.uri = this.url.toURI();
            }
            catch (URISyntaxException e) {
                this.uri = null;
            }
        }

        @Override
        public void connect() throws IOException {
            if (this.parsed) {
                return;
            }
            if (this.uri == null) {
                throw new IOException();
            }
            Matcher matcher = pattern.matcher(this.uri.getSchemeSpecificPart());
            if (matcher.matches()) {
                this.contentType = matcher.group("mimeType");
                if (this.contentType == null) {
                    this.contentType = "application/data";
                }
                this.data = matcher.group("base64") == null ? matcher.group("data").getBytes() : Base64.getDecoder().decode(matcher.group("data"));
            } else {
                throw new MalformedURLException();
            }
            this.parsed = true;
        }

        @Override
        public long getContentLengthLong() {
            long length;
            try {
                this.connect();
                length = this.data.length;
            }
            catch (IOException e) {
                length = -1L;
            }
            return length;
        }

        @Override
        public String getContentType() {
            String contentType;
            try {
                this.connect();
                contentType = this.contentType;
            }
            catch (IOException e) {
                contentType = null;
            }
            return contentType;
        }

        @Override
        public String getContentEncoding() {
            return "identity";
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return new ByteArrayInputStream(this.data);
        }
    }
}

