/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.reactive.client.internal.adapter.AdapterImplementationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveReaderAdapter<T> {
    private static final Logger log = LoggerFactory.getLogger(ReactiveReaderAdapter.class);
    private final Supplier<PulsarClient> pulsarClientSupplier;
    private final Function<PulsarClient, ReaderBuilder<T>> readerBuilderFactory;

    ReactiveReaderAdapter(Supplier<PulsarClient> pulsarClientSupplier, Function<PulsarClient, ReaderBuilder<T>> readerBuilderFactory) {
        this.pulsarClientSupplier = pulsarClientSupplier;
        this.readerBuilderFactory = readerBuilderFactory;
    }

    private Mono<Reader<T>> createReaderMono() {
        return AdapterImplementationFactory.adaptPulsarFuture(() -> this.readerBuilderFactory.apply(this.pulsarClientSupplier.get()).createAsync());
    }

    private Mono<Void> closeReader(Reader<?> reader) {
        return AdapterImplementationFactory.adaptPulsarFuture(() -> reader.closeAsync()).onErrorResume(t -> {
            log.debug("Error closing reader {}", (Object)reader, t);
            return Mono.empty();
        });
    }

    <R> Mono<R> usingReader(Function<Reader<T>, Mono<R>> usingReaderAction) {
        return Mono.usingWhen(this.createReaderMono(), usingReaderAction, this::closeReader);
    }

    <R> Flux<R> usingReaderMany(Function<Reader<T>, Flux<R>> usingReaderAction) {
        return Flux.usingWhen(this.createReaderMono(), usingReaderAction, this::closeReader);
    }
}

