/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.ProducerBuilderImpl;
import org.apache.pulsar.reactive.client.internal.adapter.AdapterImplementationFactory;
import org.apache.pulsar.reactive.client.internal.adapter.ProducerCache;
import org.apache.pulsar.reactive.client.internal.adapter.ProducerCacheKey;
import org.apache.pulsar.reactive.client.internal.api.PublisherTransformer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class ReactiveProducerAdapter<T> {
    private static final Logger log = LoggerFactory.getLogger(ReactiveProducerAdapter.class);
    private final ProducerCache producerCache;
    private final Function<PulsarClient, ProducerBuilder<T>> producerBuilderFactory;
    private final Supplier<PulsarClient> pulsarClientSupplier;
    private final Supplier<PublisherTransformer> producerActionTransformer;
    private final Object producerActionTransformerKey;

    ReactiveProducerAdapter(Supplier<PulsarClient> pulsarClientSupplier, Function<PulsarClient, ProducerBuilder<T>> producerBuilderFactory, ProducerCache producerCache, Supplier<PublisherTransformer> producerActionTransformer, Object producerActionTransformerKey) {
        this.pulsarClientSupplier = pulsarClientSupplier;
        this.producerBuilderFactory = producerBuilderFactory;
        this.producerCache = producerCache;
        this.producerActionTransformer = producerActionTransformer;
        this.producerActionTransformerKey = producerActionTransformerKey;
    }

    private Mono<Producer<T>> createProducerMono() {
        return AdapterImplementationFactory.adaptPulsarFuture(() -> this.producerBuilderFactory.apply(this.pulsarClientSupplier.get()).createAsync());
    }

    private Mono<Tuple2<ProducerCacheKey, Mono<Producer<T>>>> createCachedProducerKeyAndMono() {
        return Mono.fromCallable(() -> {
            PulsarClient pulsarClient = this.pulsarClientSupplier.get();
            ProducerBuilderImpl producerBuilder = (ProducerBuilderImpl)this.producerBuilderFactory.apply(pulsarClient);
            ProducerCacheKey cacheKey = new ProducerCacheKey(pulsarClient, producerBuilder.getConf().clone(), producerBuilder.getSchema(), this.producerActionTransformerKey);
            return Tuples.of((Object)cacheKey, AdapterImplementationFactory.adaptPulsarFuture(() -> ((ProducerBuilderImpl)producerBuilder).createAsync()));
        });
    }

    private Mono<Void> closeProducer(Producer<?> producer) {
        return AdapterImplementationFactory.adaptPulsarFuture(() -> producer.closeAsync()).onErrorResume(t -> {
            log.debug("Error closing producer {}", (Object)producer, t);
            return Mono.empty();
        });
    }

    <R> Mono<R> usingProducer(BiFunction<Producer<T>, PublisherTransformer, Mono<R>> usingProducerAction) {
        if (this.producerCache != null) {
            return this.usingCachedProducer(usingProducerAction);
        }
        return this.usingUncachedProducer(usingProducerAction);
    }

    private <R> Mono<R> usingUncachedProducer(BiFunction<Producer<T>, PublisherTransformer, Mono<R>> usingProducerAction) {
        return Mono.usingWhen(this.createProducerMono(), producer -> Mono.using(this.producerActionTransformer::get, transformer -> (Mono)usingProducerAction.apply((Producer)producer, (PublisherTransformer)transformer), Disposable::dispose), this::closeProducer);
    }

    private <R> Mono<R> usingCachedProducer(BiFunction<Producer<T>, PublisherTransformer, Mono<R>> usingProducerAction) {
        return this.createCachedProducerKeyAndMono().flatMap(keyAndProducerMono -> {
            ProducerCacheKey cacheKey = (ProducerCacheKey)keyAndProducerMono.getT1();
            Mono producerMono = (Mono)keyAndProducerMono.getT2();
            return this.producerCache.usingCachedProducer(cacheKey, producerMono, this.producerActionTransformer, usingProducerAction);
        });
    }

    <R> Flux<R> usingProducerMany(BiFunction<Producer<T>, PublisherTransformer, Flux<R>> usingProducerAction) {
        if (this.producerCache != null) {
            return this.usingCachedProducerMany(usingProducerAction);
        }
        return this.usingUncachedProducerMany(usingProducerAction);
    }

    private <R> Flux<R> usingUncachedProducerMany(BiFunction<Producer<T>, PublisherTransformer, Flux<R>> usingProducerAction) {
        return Flux.usingWhen(this.createProducerMono(), producer -> Flux.using(this.producerActionTransformer::get, transformer -> (Publisher)usingProducerAction.apply((Producer)producer, (PublisherTransformer)transformer), Disposable::dispose), this::closeProducer);
    }

    private <R> Flux<R> usingCachedProducerMany(BiFunction<Producer<T>, PublisherTransformer, Flux<R>> usingProducerAction) {
        return this.createCachedProducerKeyAndMono().flatMapMany(keyAndProducerMono -> {
            ProducerCacheKey cacheKey = (ProducerCacheKey)keyAndProducerMono.getT1();
            Mono producerMono = (Mono)keyAndProducerMono.getT2();
            return this.producerCache.usingCachedProducerMany(cacheKey, producerMono, this.producerActionTransformer, usingProducerAction);
        });
    }
}

