/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.reactive.client.internal.adapter.AdapterImplementationFactory;
import org.apache.pulsar.reactive.client.internal.api.InternalConsumerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveConsumerAdapter<T> {
    private final Supplier<PulsarClient> pulsarClientSupplier;
    private final Function<PulsarClient, ConsumerBuilder<T>> consumerBuilderFactory;
    private final Logger LOG = LoggerFactory.getLogger(ReactiveConsumerAdapter.class);

    ReactiveConsumerAdapter(Supplier<PulsarClient> pulsarClientSupplier, Function<PulsarClient, ConsumerBuilder<T>> consumerBuilderFactory) {
        this.pulsarClientSupplier = pulsarClientSupplier;
        this.consumerBuilderFactory = consumerBuilderFactory;
    }

    private Mono<Consumer<T>> createConsumerMono() {
        return Mono.deferContextual(contextView -> AdapterImplementationFactory.adaptPulsarFuture(() -> this.consumerBuilderFactory.apply(this.pulsarClientSupplier.get()).subscribeAsync()).doOnSuccess(consumer -> contextView.getOrEmpty(InternalConsumerListener.class).ifPresent(listener -> listener.onConsumerCreated(consumer))));
    }

    private Mono<Void> closeConsumer(Consumer<?> consumer) {
        return Mono.deferContextual(contextView -> AdapterImplementationFactory.adaptPulsarFuture(() -> ((Consumer)consumer).closeAsync()).onErrorResume(t -> {
            this.LOG.debug("Error closing consumer {}", (Object)consumer, t);
            return Mono.empty();
        }).doFinally(signalType -> {
            this.LOG.info("Consumer closed {}", (Object)consumer);
            contextView.getOrEmpty(InternalConsumerListener.class).ifPresent(listener -> listener.onConsumerClosed((Object)consumer));
        }));
    }

    <R> Mono<R> usingConsumer(Function<Consumer<T>, Mono<R>> usingConsumerAction) {
        return Mono.usingWhen(this.createConsumerMono(), usingConsumerAction, this::closeConsumer);
    }

    <R> Flux<R> usingConsumerMany(Function<Consumer<T>, Flux<R>> usingConsumerAction) {
        return Flux.usingWhen(this.createConsumerMono(), usingConsumerAction, this::closeConsumer);
    }
}

