/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.pulsar.reactive.client.adapter.ProducerCacheProvider;

public class ConcurrentHashMapProducerCacheProvider
implements ProducerCacheProvider {
    private final ConcurrentHashMap<Object, CompletableFuture<Object>> cache = new ConcurrentHashMap();

    @Override
    public <K, V> CompletableFuture<V> getOrCreateCachedEntry(K key, Function<K, CompletableFuture<V>> createEntryFunction) {
        return this.cache.computeIfAbsent(key, __ -> (CompletableFuture)createEntryFunction.apply(key));
    }

    @Override
    public void close() {
        for (CompletableFuture<Object> future : this.cache.values()) {
            future.thenAccept(value -> {
                if (value instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)value).close();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.cache.clear();
        }
    }
}

