/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.writer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaWriter;

public class JacksonJsonWriter<T>
implements SchemaWriter<T> {
    private final ObjectMapper objectMapper;

    public JacksonJsonWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public byte[] write(T message) {
        try {
            return this.objectMapper.writeValueAsBytes(message);
        }
        catch (JsonProcessingException e) {
            throw new SchemaSerializationException((Throwable)e);
        }
    }
}

