/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class SameAuthParamsLookupAutoClusterFailover
implements ServiceUrlProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SameAuthParamsLookupAutoClusterFailover.class);
    private PulsarClientImpl pulsarClient;
    private EventLoopGroup executor;
    private volatile boolean closed;
    private ScheduledFuture<?> scheduledCheckTask;
    private int failoverThreshold = 5;
    private int recoverThreshold = 5;
    private long checkHealthyIntervalMs = 1000L;
    private boolean markTopicNotFoundAsAvailable = true;
    private String testTopic = "public/default/tp_test";
    private String[] pulsarServiceUrlArray;
    private PulsarServiceState[] pulsarServiceStateArray;
    private MutableInt[] checkCounterArray;
    private volatile int currentPulsarServiceIndex;

    private SameAuthParamsLookupAutoClusterFailover() {
    }

    public void initialize(PulsarClient client) {
        this.currentPulsarServiceIndex = 0;
        this.pulsarClient = (PulsarClientImpl)client;
        this.executor = EventLoopUtil.newEventLoopGroup((int)1, (boolean)false, (ThreadFactory)((Object)new ExecutorProvider.ExtendedThreadFactory("broker-service-url-check")));
        this.scheduledCheckTask = this.executor.scheduleAtFixedRate(() -> {
            if (this.closed) {
                return;
            }
            this.checkPulsarServices();
            int firstHealthyPulsarService = this.firstHealthyPulsarService();
            if (firstHealthyPulsarService == this.currentPulsarServiceIndex) {
                return;
            }
            if (firstHealthyPulsarService < 0) {
                int failoverTo = this.findFailoverTo();
                if (failoverTo < 0) {
                    log.error("Failed to choose a pulsar service to connect, no one pulsar service is healthy. Current pulsar service: [{}] {}. States: {}, Counters: {}", new Object[]{this.currentPulsarServiceIndex, this.pulsarServiceUrlArray[this.currentPulsarServiceIndex], Arrays.toString((Object[])this.pulsarServiceStateArray), Arrays.toString(this.checkCounterArray)});
                } else {
                    this.updateServiceUrl(failoverTo);
                }
            } else {
                this.updateServiceUrl(firstHealthyPulsarService);
            }
        }, this.checkHealthyIntervalMs, this.checkHealthyIntervalMs, TimeUnit.MILLISECONDS);
    }

    public String getServiceUrl() {
        return this.pulsarServiceUrlArray[this.currentPulsarServiceIndex];
    }

    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        log.info("Closing service url provider. Current pulsar service: [{}] {}", (Object)this.currentPulsarServiceIndex, (Object)this.pulsarServiceUrlArray[this.currentPulsarServiceIndex]);
        if (this.scheduledCheckTask != null) {
            this.scheduledCheckTask.cancel(false);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.closed = true;
    }

    private int firstHealthyPulsarService() {
        for (int i = 0; i <= this.currentPulsarServiceIndex; ++i) {
            if (this.pulsarServiceStateArray[i] != PulsarServiceState.Healthy && this.pulsarServiceStateArray[i] != PulsarServiceState.PreFail) continue;
            return i;
        }
        return -1;
    }

    private int findFailoverTo() {
        for (int i = this.currentPulsarServiceIndex + 1; i <= this.pulsarServiceUrlArray.length; ++i) {
            if (!this.probeAvailable(i)) continue;
            return i;
        }
        return -1;
    }

    private void checkPulsarServices() {
        block12: for (int i = 0; i <= this.currentPulsarServiceIndex; ++i) {
            if (this.probeAvailable(i)) {
                switch (this.pulsarServiceStateArray[i]) {
                    case Healthy: {
                        break;
                    }
                    case PreFail: {
                        this.pulsarServiceStateArray[i] = PulsarServiceState.Healthy;
                        this.checkCounterArray[i].setValue(0);
                        break;
                    }
                    case Failed: {
                        this.pulsarServiceStateArray[i] = PulsarServiceState.PreRecover;
                        this.checkCounterArray[i].setValue(1);
                        break;
                    }
                    case PreRecover: {
                        this.checkCounterArray[i].setValue(this.checkCounterArray[i].getValue() + 1);
                        if (this.checkCounterArray[i].getValue() < this.recoverThreshold) break;
                        this.pulsarServiceStateArray[i] = PulsarServiceState.Healthy;
                        this.checkCounterArray[i].setValue(0);
                    }
                }
                continue;
            }
            switch (this.pulsarServiceStateArray[i]) {
                case Healthy: {
                    this.pulsarServiceStateArray[i] = PulsarServiceState.PreFail;
                    this.checkCounterArray[i].setValue(1);
                    continue block12;
                }
                case PreFail: {
                    this.checkCounterArray[i].setValue(this.checkCounterArray[i].getValue() + 1);
                    if (this.checkCounterArray[i].getValue() < this.failoverThreshold) continue block12;
                    this.pulsarServiceStateArray[i] = PulsarServiceState.Failed;
                    this.checkCounterArray[i].setValue(0);
                    continue block12;
                }
                case Failed: {
                    continue block12;
                }
                case PreRecover: {
                    this.pulsarServiceStateArray[i] = PulsarServiceState.Failed;
                    this.checkCounterArray[i].setValue(0);
                }
            }
        }
    }

    private boolean probeAvailable(int brokerServiceIndex) {
        String url = this.pulsarServiceUrlArray[brokerServiceIndex];
        try {
            Pair<InetSocketAddress, InetSocketAddress> res = this.pulsarClient.getLookup(url).getBroker(TopicName.get((String)this.testTopic)).get(3L, TimeUnit.SECONDS);
            if (log.isDebugEnabled()) {
                log.debug("Success to probe available(lookup res: {}), [{}] {}}. States: {}, Counters: {}", new Object[]{res.toString(), brokerServiceIndex, url, Arrays.toString((Object[])this.pulsarServiceStateArray), Arrays.toString(this.checkCounterArray)});
            }
            return true;
        }
        catch (Exception e) {
            Throwable actEx = FutureUtil.unwrapCompletionException((Throwable)e);
            if (actEx instanceof PulsarAdminException.NotFoundException || actEx instanceof PulsarClientException.NotFoundException || actEx instanceof PulsarClientException.TopicDoesNotExistException || actEx instanceof PulsarClientException.LookupException) {
                if (this.markTopicNotFoundAsAvailable) {
                    if (log.isDebugEnabled()) {
                        log.debug("Success to probe available(case tenant/namespace/topic not found), [{}] {}. States: {}, Counters: {}", new Object[]{brokerServiceIndex, url, Arrays.toString((Object[])this.pulsarServiceStateArray), Arrays.toString(this.checkCounterArray)});
                    }
                    return true;
                }
                log.warn("Failed to probe available(error tenant/namespace/topic not found), [{}] {}. States: {}, Counters: {}", new Object[]{brokerServiceIndex, url, Arrays.toString((Object[])this.pulsarServiceStateArray), Arrays.toString(this.checkCounterArray)});
                return false;
            }
            log.warn("Failed to probe available, [{}] {}. States: {}, Counters: {}", new Object[]{brokerServiceIndex, url, Arrays.toString((Object[])this.pulsarServiceStateArray), Arrays.toString(this.checkCounterArray)});
            return false;
        }
    }

    private void updateServiceUrl(int targetIndex) {
        String currentUrl = this.pulsarServiceUrlArray[this.currentPulsarServiceIndex];
        String targetUrl = this.pulsarServiceUrlArray[targetIndex];
        String logMsg = targetIndex < this.currentPulsarServiceIndex ? String.format("Recover to high priority pulsar service [%s] %s --> [%s] %s. States: %s, Counters: %s", this.currentPulsarServiceIndex, currentUrl, targetIndex, targetUrl, Arrays.toString((Object[])this.pulsarServiceStateArray), Arrays.toString(this.checkCounterArray)) : String.format("Failover to low priority pulsar service [%s] %s --> [%s] %s. States: %s, Counters: %s", this.currentPulsarServiceIndex, currentUrl, targetIndex, targetUrl, Arrays.toString((Object[])this.pulsarServiceStateArray), Arrays.toString(this.checkCounterArray));
        log.info(logMsg);
        try {
            this.pulsarClient.updateServiceUrl(targetUrl);
            this.pulsarClient.reloadLookUp();
            this.currentPulsarServiceIndex = targetIndex;
        }
        catch (Exception e) {
            log.error("Failed to {}", (Object)logMsg, (Object)e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public int getFailoverThreshold() {
        return this.failoverThreshold;
    }

    @Generated
    public int getRecoverThreshold() {
        return this.recoverThreshold;
    }

    @Generated
    public long getCheckHealthyIntervalMs() {
        return this.checkHealthyIntervalMs;
    }

    @Generated
    public boolean isMarkTopicNotFoundAsAvailable() {
        return this.markTopicNotFoundAsAvailable;
    }

    @Generated
    public String getTestTopic() {
        return this.testTopic;
    }

    @Generated
    public int getCurrentPulsarServiceIndex() {
        return this.currentPulsarServiceIndex;
    }

    static /* synthetic */ String[] access$602(SameAuthParamsLookupAutoClusterFailover x0, String[] x1) {
        x0.pulsarServiceUrlArray = x1;
        return x1;
    }

    static /* synthetic */ PulsarServiceState[] access$702(SameAuthParamsLookupAutoClusterFailover x0, PulsarServiceState[] x1) {
        x0.pulsarServiceStateArray = x1;
        return x1;
    }

    static /* synthetic */ MutableInt[] access$802(SameAuthParamsLookupAutoClusterFailover x0, MutableInt[] x1) {
        x0.checkCounterArray = x1;
        return x1;
    }

    public static enum PulsarServiceState {
        Healthy,
        PreFail,
        Failed,
        PreRecover;

    }

    public static class Builder {
        private SameAuthParamsLookupAutoClusterFailover sameAuthParamsLookupAutoClusterFailover = new SameAuthParamsLookupAutoClusterFailover();

        public Builder failoverThreshold(int failoverThreshold) {
            if (failoverThreshold < 1) {
                throw new IllegalArgumentException("failoverThreshold must be larger than 0");
            }
            this.sameAuthParamsLookupAutoClusterFailover.failoverThreshold = failoverThreshold;
            return this;
        }

        public Builder recoverThreshold(int recoverThreshold) {
            if (recoverThreshold < 1) {
                throw new IllegalArgumentException("recoverThreshold must be larger than 0");
            }
            this.sameAuthParamsLookupAutoClusterFailover.recoverThreshold = recoverThreshold;
            return this;
        }

        public Builder checkHealthyIntervalMs(int checkHealthyIntervalMs) {
            if (checkHealthyIntervalMs < 1) {
                throw new IllegalArgumentException("checkHealthyIntervalMs must be larger than 0");
            }
            this.sameAuthParamsLookupAutoClusterFailover.checkHealthyIntervalMs = checkHealthyIntervalMs;
            return this;
        }

        public Builder testTopic(String testTopic) {
            if (StringUtils.isBlank((CharSequence)testTopic) && TopicName.get((String)testTopic) != null) {
                throw new IllegalArgumentException("testTopic can not be blank");
            }
            this.sameAuthParamsLookupAutoClusterFailover.testTopic = testTopic;
            return this;
        }

        public Builder markTopicNotFoundAsAvailable(boolean markTopicNotFoundAsAvailable) {
            this.sameAuthParamsLookupAutoClusterFailover.markTopicNotFoundAsAvailable = markTopicNotFoundAsAvailable;
            return this;
        }

        public Builder pulsarServiceUrlArray(String[] pulsarServiceUrlArray) {
            if (pulsarServiceUrlArray == null || pulsarServiceUrlArray.length == 0) {
                throw new IllegalArgumentException("pulsarServiceUrlArray can not be empty");
            }
            SameAuthParamsLookupAutoClusterFailover.access$602(this.sameAuthParamsLookupAutoClusterFailover, pulsarServiceUrlArray);
            int pulsarServiceLen = pulsarServiceUrlArray.length;
            HashSet<String> uniqueChecker = new HashSet<String>();
            for (int i = 0; i < pulsarServiceLen; ++i) {
                String pulsarService = pulsarServiceUrlArray[i];
                if (StringUtils.isBlank((CharSequence)pulsarService)) {
                    throw new IllegalArgumentException("pulsarServiceUrlArray contains a blank value at index " + i);
                }
                if (pulsarService.startsWith("http") || pulsarService.startsWith("HTTP")) {
                    throw new IllegalArgumentException("SameAuthParamsLookupAutoClusterFailover does not support HTTP protocol pulsar service url so far.");
                }
                if (uniqueChecker.add(pulsarService)) continue;
                throw new IllegalArgumentException("pulsarServiceUrlArray contains duplicated value " + pulsarServiceUrlArray[i]);
            }
            return this;
        }

        public SameAuthParamsLookupAutoClusterFailover build() {
            String[] pulsarServiceUrlArray = this.sameAuthParamsLookupAutoClusterFailover.pulsarServiceUrlArray;
            if (pulsarServiceUrlArray == null) {
                throw new IllegalArgumentException("pulsarServiceUrlArray can not be empty");
            }
            int pulsarServiceLen = pulsarServiceUrlArray.length;
            SameAuthParamsLookupAutoClusterFailover.access$702(this.sameAuthParamsLookupAutoClusterFailover, new PulsarServiceState[pulsarServiceLen]);
            SameAuthParamsLookupAutoClusterFailover.access$802(this.sameAuthParamsLookupAutoClusterFailover, new MutableInt[pulsarServiceLen]);
            for (int i = 0; i < pulsarServiceLen; ++i) {
                ((SameAuthParamsLookupAutoClusterFailover)this.sameAuthParamsLookupAutoClusterFailover).pulsarServiceStateArray[i] = PulsarServiceState.Healthy;
                ((SameAuthParamsLookupAutoClusterFailover)this.sameAuthParamsLookupAutoClusterFailover).checkCounterArray[i] = new MutableInt(0);
            }
            return this.sameAuthParamsLookupAutoClusterFailover;
        }
    }
}

