/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import lombok.Generated;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.impl.auth.PulsarSaslClient;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslAuthenticationDataProvider
implements AuthenticationDataProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaslAuthenticationDataProvider.class);
    private static final long serialVersionUID = 1L;
    private PulsarSaslClient pulsarSaslClient;

    public SaslAuthenticationDataProvider(PulsarSaslClient pulsarSaslClient) {
        this.pulsarSaslClient = pulsarSaslClient;
    }

    public boolean hasDataFromCommand() {
        return true;
    }

    public AuthData authenticate(AuthData commandData) throws AuthenticationException {
        if (Arrays.equals(commandData.getBytes(), AuthData.INIT_AUTH_DATA_BYTES)) {
            if (this.pulsarSaslClient.hasInitialResponse()) {
                return this.pulsarSaslClient.evaluateChallenge(AuthData.of((byte[])new byte[0]));
            }
            return AuthData.of((byte[])new byte[0]);
        }
        return this.pulsarSaslClient.evaluateChallenge(commandData);
    }

    public boolean hasDataForHttp() {
        return true;
    }

    public Set<Map.Entry<String, String>> getHttpHeaders() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("SASL-Type", "Kerberos");
        return headers.entrySet();
    }
}

