/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import lombok.Generated;

public class ResourceQuota {
    private double msgRateIn = 0.0;
    private double msgRateOut = 0.0;
    private double bandwidthIn = 0.0;
    private double bandwidthOut = 0.0;
    private double memory = 0.0;
    private boolean dynamic = true;

    public boolean getDynamic() {
        return this.dynamic;
    }

    public void add(ResourceQuota quota) {
        this.msgRateIn += quota.msgRateIn;
        this.msgRateOut += quota.msgRateOut;
        this.bandwidthIn += quota.bandwidthIn;
        this.bandwidthOut += quota.bandwidthOut;
        this.memory += quota.memory;
    }

    public void substract(ResourceQuota quota) {
        this.msgRateIn -= quota.msgRateIn;
        this.msgRateOut -= quota.msgRateOut;
        this.bandwidthIn -= quota.bandwidthIn;
        this.bandwidthOut -= quota.bandwidthOut;
        this.memory -= quota.memory;
    }

    @Generated
    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    @Generated
    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    @Generated
    public double getBandwidthIn() {
        return this.bandwidthIn;
    }

    @Generated
    public double getBandwidthOut() {
        return this.bandwidthOut;
    }

    @Generated
    public double getMemory() {
        return this.memory;
    }

    @Generated
    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    @Generated
    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    @Generated
    public void setBandwidthIn(double bandwidthIn) {
        this.bandwidthIn = bandwidthIn;
    }

    @Generated
    public void setBandwidthOut(double bandwidthOut) {
        this.bandwidthOut = bandwidthOut;
    }

    @Generated
    public void setMemory(double memory) {
        this.memory = memory;
    }

    @Generated
    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceQuota)) {
            return false;
        }
        ResourceQuota other = (ResourceQuota)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgRateIn(), other.getMsgRateIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getBandwidthIn(), other.getBandwidthIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getBandwidthOut(), other.getBandwidthOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemory(), other.getMemory()) != 0) {
            return false;
        }
        return this.getDynamic() == other.getDynamic();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceQuota;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateIn = Double.doubleToLongBits(this.getMsgRateIn());
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $bandwidthIn = Double.doubleToLongBits(this.getBandwidthIn());
        result = result * 59 + (int)($bandwidthIn >>> 32 ^ $bandwidthIn);
        long $bandwidthOut = Double.doubleToLongBits(this.getBandwidthOut());
        result = result * 59 + (int)($bandwidthOut >>> 32 ^ $bandwidthOut);
        long $memory = Double.doubleToLongBits(this.getMemory());
        result = result * 59 + (int)($memory >>> 32 ^ $memory);
        result = result * 59 + (this.getDynamic() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "ResourceQuota(msgRateIn=" + this.getMsgRateIn() + ", msgRateOut=" + this.getMsgRateOut() + ", bandwidthIn=" + this.getBandwidthIn() + ", bandwidthOut=" + this.getBandwidthOut() + ", memory=" + this.getMemory() + ", dynamic=" + this.getDynamic() + ")";
    }
}

