/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.MessageMetadata;

public interface Dispatcher {
    public CompletableFuture<Void> addConsumer(Consumer var1);

    public void removeConsumer(Consumer var1) throws BrokerServiceException;

    public void consumerFlow(Consumer var1, int var2);

    public boolean isConsumerConnected();

    public List<Consumer> getConsumers();

    public boolean canUnsubscribe(Consumer var1);

    default public CompletableFuture<Void> close() {
        return this.close(true, Optional.empty());
    }

    public CompletableFuture<Void> close(boolean var1, Optional<BrokerLookupData> var2);

    public boolean isClosed();

    public CompletableFuture<Void> disconnectActiveConsumers(boolean var1);

    default public CompletableFuture<Void> disconnectAllConsumers(boolean isResetCursor) {
        return this.disconnectAllConsumers(isResetCursor, Optional.empty());
    }

    default public CompletableFuture<Void> disconnectAllConsumers() {
        return this.disconnectAllConsumers(false);
    }

    public CompletableFuture<Void> disconnectAllConsumers(boolean var1, Optional<BrokerLookupData> var2);

    public void resetCloseFuture();

    public void reset();

    public CommandSubscribe.SubType getType();

    public void redeliverUnacknowledgedMessages(Consumer var1, long var2);

    public void redeliverUnacknowledgedMessages(Consumer var1, List<PositionImpl> var2);

    public void addUnAckedMessages(int var1);

    public RedeliveryTracker getRedeliveryTracker();

    default public Optional<DispatchRateLimiter> getRateLimiter() {
        return Optional.empty();
    }

    default public void updateRateLimiter() {
        this.initializeDispatchRateLimiterIfNeeded();
        this.getRateLimiter().ifPresent(DispatchRateLimiter::updateDispatchRate);
    }

    default public boolean initializeDispatchRateLimiterIfNeeded() {
        return false;
    }

    default public boolean trackDelayedDelivery(long ledgerId, long entryId, MessageMetadata msgMetadata) {
        return false;
    }

    default public long getNumberOfDelayedMessages() {
        return 0L;
    }

    default public CompletableFuture<Void> clearDelayedMessages() {
        return CompletableFuture.completedFuture(null);
    }

    default public void cursorIsReset() {
    }

    default public void markDeletePositionMoveForward() {
    }

    default public boolean checkAndUnblockIfStuck() {
        return false;
    }

    default public void afterAckMessages(Throwable exOfDeletion, Object ctxOfDeletion) {
    }

    default public boolean checkAndResumeIfPaused() {
        return false;
    }

    default public long getFilterProcessedMsgCount() {
        return 0L;
    }

    default public long getFilterAcceptedMsgCount() {
        return 0L;
    }

    default public long getFilterRejectedMsgCount() {
        return 0L;
    }

    default public long getFilterRescheduledMsgCount() {
        return 0L;
    }
}

